/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.common.entity.passive.SmallBirdEntity;

public class WhiteCollaredOlivebackModel
extends HierarchicalModel<SmallBirdEntity> {
    private final ModelPart body;
    private final ModelPart butt;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart head;
    private final ModelPart beak;
    private final ModelPart legLeft;
    private final ModelPart legRight;
    private final ModelPart wingLeft;
    private final ModelPart wingRight;

    public WhiteCollaredOlivebackModel(ModelPart root) {
        this.body = root.getChild("body_base");
        this.butt = this.body.getChild("birb_butt");
        this.tail2 = this.butt.getChild("tail2");
        this.tail1 = this.butt.getChild("tail1");
        this.head = this.body.getChild("lil_head");
        this.beak = this.head.getChild("Beak");
        this.legLeft = this.body.getChild("leg_left");
        this.wingLeft = this.body.getChild("wing_left");
        this.legRight = this.body.getChild("leg_right");
        this.wingRight = this.body.getChild("wing_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition body = mesh.getRoot().addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-1.005f, -3.0f, -2.0f, 2.01f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)22.25f, (float)-0.5f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition butt = body.addOrReplaceChild("birb_butt", CubeListBuilder.create().texOffs(7, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)1.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        butt.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(9, 14).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        butt.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(8, 11).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("lil_head", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-2.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("Beak", CubeListBuilder.create().texOffs(12, 3).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.75f, (float)-2.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(4, 7).addBox(0.0f, 0.25f, 0.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.75f, (float)-1.2654f, (float)-0.5236f, (float)-0.4363f));
        body.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(6, 7).addBox(-1.0f, 0.25f, 0.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.75f, (float)-1.2654f, (float)0.5236f, (float)0.4363f));
        body.addOrReplaceChild("wing_left", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)-1.75f, (float)0.3491f, (float)0.0873f, (float)-0.3054f));
        body.addOrReplaceChild("wing_right", CubeListBuilder.create().texOffs(8, 6).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)-1.75f, (float)0.3491f, (float)-0.0873f, (float)0.3054f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16);
    }

    public ModelPart root() {
        return this.body;
    }

    public void setupAnim(SmallBirdEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot += headPitch * ((float)Math.PI / 180);
        this.head.yRot += headYaw * ((float)Math.PI / 180);
        float partialTicks = ageInTicks - (float)entity.tickCount;
        float flightAnimation = entity.getFlightAnimation(partialTicks);
        float groundAnimation = 1.0f - flightAnimation;
        if (flightAnimation > 0.0f) {
            this.legLeft.xRot += 1.2217305f * flightAnimation;
            this.legRight.xRot += 1.2217305f * flightAnimation;
            this.wingLeft.xRot += 1.5707964f * flightAnimation;
            this.wingRight.xRot += 1.5707964f * flightAnimation;
            try (ModelAnimator.Cycle fly = ModelAnimator.cycle(ageInTicks * 0.3f, flightAnimation);){
                this.body.y += fly.eval(1.0f, 0.2f, -0.06f, 0.0f);
                this.body.xRot += fly.eval(0.5f, -0.1f, -0.06f, 0.2f);
                this.head.xRot += fly.eval(0.5f, 0.1f, -0.1f, 0.0f);
                this.wingLeft.zRot += fly.eval(1.0f, 1.3f, -0.1f, 1.4f);
                this.wingRight.zRot += fly.eval(1.0f, -1.3f, -0.1f, -1.4f);
            }
        }
        if (groundAnimation > 0.0f) {
            try (ModelAnimator.Cycle walk = ModelAnimator.cycle(limbSwing * 0.5f, limbSwingAmount * groundAnimation);){
                this.legLeft.xRot += walk.eval(1.0f, 1.0f, 0.0f, 0.5f);
                this.legRight.xRot += walk.eval(1.0f, 1.0f, 0.0f, 0.5f);
                this.body.y += walk.eval(1.0f, 1.2f, -0.06f, 0.0f);
                this.wingLeft.yRot += walk.eval(2.0f, 0.5f, 0.0f, 1.0f);
                this.wingRight.yRot += walk.eval(2.0f, -0.5f, 0.0f, -1.0f);
            }
            try (ModelAnimator.Cycle idle = ModelAnimator.cycle(ageInTicks, 1.0f);){
                float wingTwitch = idle.twitchSymmetric(12.0f, 0.22f, 0.5f);
                this.wingLeft.yRot += wingTwitch;
                this.wingLeft.xRot += wingTwitch * 0.5f;
                this.wingRight.yRot -= wingTwitch;
                this.wingRight.xRot += wingTwitch * 0.5f;
                this.head.zRot += idle.twitchSymmetric(9.0f, 0.2f, 0.15f);
            }
        }
    }
}

