/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;

public class VMonkeyModel
extends HierarchicalModel<VMonkeyEntity>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart lLegUpper;
    private final ModelPart rLegUpper;
    private final ModelPart rArmUpper;
    private final ModelPart lArmUpper;
    private final ModelPart tailBase;
    private final ModelPart tailMid;
    private final ModelPart tailTop;
    private final ModelPart rArmLower;
    private final ModelPart lArmLower;
    private final ModelPart lLegLower;
    private final ModelPart rLegLower;
    private final ModelPart face;
    private final ModelPart head;
    @Nullable
    protected RandomSource rand;

    public VMonkeyModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.lLegUpper = root.getChild("lLegUpper");
        this.rLegUpper = root.getChild("rLegUpper");
        this.rArmUpper = root.getChild("rArmUpper");
        this.lArmUpper = root.getChild("lArmUpper");
        this.tailBase = root.getChild("tailBase");
        this.tailMid = root.getChild("tailMid");
        this.tailTop = root.getChild("tailTop");
        this.rArmLower = root.getChild("rArmLower");
        this.lArmLower = root.getChild("lArmLower");
        this.lLegLower = root.getChild("lLegLower");
        this.rLegLower = root.getChild("rLegLower");
        this.face = root.getChild("face");
        this.head = root.getChild("head");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, -2.0f, -4.0f, 2.0f, 4.0f, 9.0f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.addOrReplaceChild("lLegUpper", CubeListBuilder.create().texOffs(7, 0).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("rLegUpper", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)14.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("rArmUpper", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)14.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("lArmUpper", CubeListBuilder.create().texOffs(7, 0).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("tailBase", CubeListBuilder.create().texOffs(20, 27).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)3.5f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.addOrReplaceChild("tailMid", CubeListBuilder.create().texOffs(20, 24).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)3.5f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.addOrReplaceChild("tailTop", CubeListBuilder.create().texOffs(20, 21).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)3.5f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.addOrReplaceChild("rArmLower", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)19.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("lArmLower", CubeListBuilder.create().texOffs(12, 0).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)19.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("lLegLower", CubeListBuilder.create().texOffs(12, 0).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)19.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("rLegLower", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)19.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("face", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -1.0f, 0.0f, 4.0f, 4.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)-5.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(25, 25).addBox(-3.0f, -2.0f, 0.0f, 6.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)-5.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(VMonkeyEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = ageInTicks - (float)entity.tickCount;
        this.face.yRot = netHeadYaw * ((float)Math.PI / 180) + (float)Math.PI;
        this.face.xRot = headPitch * ((float)Math.PI / 180);
        if (entity.isOrderedToSit()) {
            this.body.setPos(0.0f, 20.0f, 0.0f);
            this.body.xRot = 0.9320058f;
            this.body.yRot = (float)Math.PI;
            this.lLegUpper.setPos(-1.0f, 16.0f, -1.5f);
            this.lLegUpper.xRot = -0.2792527f;
            this.rLegUpper.setPos(1.0f, 16.0f, -1.5f);
            this.rLegUpper.xRot = -0.2792527f;
            this.rLegUpper.yRot = 0.005817764f;
            this.rArmUpper.setPos(1.0f, 22.0f, 3.5f);
            this.rArmUpper.xRot = -2.142101f;
            this.lArmUpper.setPos(-1.0f, 22.0f, 3.5f);
            this.lArmUpper.xRot = -2.142043f;
            this.tailBase.setPos(0.0f, 22.0f, 2.466667f);
            this.tailBase.xRot = 1.902409f;
            this.tailBase.yRot = (float)Math.PI;
            this.tailMid.setPos(0.0f, 23.3f, 5.966667f);
            this.tailMid.xRot = 1.5707964f;
            this.tailMid.yRot = 2.111848f;
            this.tailMid.zRot = -0.2617994f;
            this.tailTop.setPos(-1.0f, 23.2f, 7.0f);
            this.tailTop.xRot = 1.5707964f;
            this.tailTop.yRot = 0.8377581f;
            this.tailTop.zRot = (float)Math.PI / 180;
            this.rArmLower.setPos(1.0f, 19.0f, -0.5f);
            this.rArmLower.xRot = -0.1489348f;
            this.lArmLower.setPos(-1.0f, 19.0f, -0.3f);
            this.lArmLower.xRot = -0.1492257f;
            this.lLegLower.setPos(-1.0f, 21.0f, -2.8f);
            this.lLegLower.xRot = -0.9599311f;
            this.rLegLower.setPos(1.0f, 21.0f, -2.833333f);
            this.rLegLower.xRot = -0.9599311f;
            this.face.setPos(0.0f, 15.0f, -3.0f);
            this.head.setPos(0.0f, 15.0f, -3.0f);
        } else if (entity.isClimbing()) {
            this.body.xRot = 1.5707964f;
            this.body.setPos(0.0f, 16.0f, 0.0f);
            this.lLegUpper.setPos(-1.0f, 12.0f, 2.0f);
            this.rLegUpper.setPos(1.0f, 12.0f, 2.0f);
            this.rArmUpper.setPos(1.0f, 19.5f, 2.0f);
            this.lArmUpper.setPos(-1.0f, 19.5f, 2.0f);
            this.tailBase.setPos(0.0f, 19.5f, 0.5f);
            this.tailBase.xRot = 1.5707964f;
            this.tailBase.yRot = (float)Math.PI;
            this.tailMid.setPos(0.0f, 19.5f, 4.5f);
            this.tailMid.xRot = 1.5707964f;
            this.tailMid.yRot = (float)Math.PI;
            this.tailTop.setPos(0.0f, 19.5f, 6.5f);
            this.tailTop.xRot = 1.5707964f;
            this.tailTop.yRot = (float)Math.PI;
            this.rArmLower.setPos(1.0f, 19.5f, -3.0f);
            this.lArmLower.setPos(-1.0f, 19.5f, -3.0f);
            this.lLegLower.setPos(-1.0f, 12.0f, -3.0f);
            this.rLegLower.setPos(1.0f, 12.0f, -3.0f);
            this.face.setPos(0.0f, 11.0f, 1.0f);
            this.face.xRot += 1.5707964f;
            this.head.setPos(0.0f, 11.0f, 1.0f);
            this.rLegUpper.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 0.75f * partialTicks - 1.5707964f;
            this.rArmUpper.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 0.75f * partialTicks - 1.5707964f;
            this.lArmUpper.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 0.75f * partialTicks - 1.5707964f;
            this.lLegUpper.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 0.75f * partialTicks - 1.5707964f;
            this.rLegLower.setPos(1.0f, 12.0f + Mth.cos((float)this.rLegUpper.xRot) * 5.0f, -3.0f - (5.0f + Mth.sin((float)this.rLegUpper.xRot) * 5.0f));
            this.rArmLower.setPos(1.0f, 19.5f + Mth.cos((float)this.rArmUpper.xRot) * 5.0f, -3.0f - (5.0f + Mth.sin((float)this.rArmUpper.xRot) * 5.0f));
            this.lArmLower.setPos(-1.0f, 19.5f + Mth.cos((float)this.lArmUpper.xRot) * 5.0f, -3.0f - (5.0f + Mth.sin((float)this.lArmUpper.xRot) * 5.0f));
            this.lLegLower.setPos(-1.0f, 12.0f + Mth.cos((float)this.lLegUpper.xRot) * 5.0f, -3.0f - (5.0f + Mth.sin((float)this.lLegUpper.xRot) * 5.0f));
            this.rLegLower.xRot = this.rLegUpper.xRot - 0.6981317f;
            this.rArmLower.xRot = this.rArmUpper.xRot + 0.6981317f;
            this.lLegLower.xRot = this.lLegUpper.xRot - 0.6981317f;
            this.lArmLower.xRot = this.lArmUpper.xRot + 0.6981317f;
        } else {
            this.body.setPos(0.0f, 16.0f, 0.0f);
            this.body.yRot = (float)Math.PI;
            this.body.xRot = 0.0f;
            this.lLegUpper.setPos(-1.0f, 14.0f, -3.5f);
            this.rLegUpper.setPos(1.0f, 14.0f, -3.5f);
            this.rArmUpper.setPos(1.0f, 14.0f, 3.5f);
            this.lArmUpper.setPos(-1.0f, 14.0f, 3.5f);
            this.tailBase.setPos(0.0f, 15.0f, 3.5f);
            this.tailBase.xRot = 0.0f;
            this.tailBase.yRot = (float)Math.PI;
            this.tailBase.zRot = 0.0f;
            this.tailMid.setPos(0.0f, 11.0f, 3.5f);
            this.tailMid.xRot = 0.0f;
            this.tailMid.yRot = (float)Math.PI;
            this.tailMid.zRot = 0.0f;
            this.tailTop.setPos(0.0f, 9.0f, 3.5f);
            this.tailTop.xRot = 0.0f;
            this.tailTop.yRot = (float)Math.PI;
            this.tailTop.zRot = 0.0f;
            this.face.setPos(0.0f, 15.0f, -5.0f);
            this.head.setPos(0.0f, 15.0f, -5.0f);
            this.rLegUpper.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.75f * limbSwingAmount;
            this.rArmUpper.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
            this.lLegUpper.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
            this.lArmUpper.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.75f * limbSwingAmount;
            this.rLegLower.setPos(1.0f, 19.0f - (5.0f - Mth.sin((float)(this.rLegUpper.xRot + 1.5707964f)) * 5.0f), -3.5f - Mth.cos((float)(this.rLegUpper.xRot + 1.5707964f)) * 5.0f);
            this.rArmLower.setPos(1.0f, 19.0f - (5.0f - Mth.sin((float)(this.rArmUpper.xRot + 1.5707964f)) * 5.0f), 3.5f - Mth.cos((float)(this.rArmUpper.xRot + 1.5707964f)) * 5.0f);
            this.lArmLower.setPos(-1.0f, 19.0f - (5.0f - Mth.sin((float)(this.lArmUpper.xRot + 1.5707964f)) * 5.0f), 3.5f - Mth.cos((float)(this.lArmUpper.xRot + 1.5707964f)) * 5.0f);
            this.lLegLower.setPos(-1.0f, 19.0f - (5.0f - Mth.sin((float)(this.lLegUpper.xRot + 1.5707964f)) * 5.0f), -3.5f - Mth.cos((float)(this.lLegUpper.xRot + 1.5707964f)) * 5.0f);
            this.rLegLower.xRot = this.rLegUpper.xRot;
            this.rArmLower.xRot = this.rArmUpper.xRot;
            this.lLegLower.xRot = this.lLegUpper.xRot;
            this.lArmLower.xRot = this.lArmUpper.xRot;
            this.tailBase.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
            this.tailBase.zRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
            this.tailMid.setPos(0.0f - Mth.cos((float)(this.tailBase.zRot + 1.5707964f)) * 3.0f, 11.0f + (3.0f - Mth.sin((float)(this.tailBase.xRot + 1.5707964f)) * 3.0f), 3.5f - Mth.cos((float)(this.tailBase.xRot + 1.5707964f)) * 3.0f);
            this.tailMid.xRot = this.tailBase.xRot + Mth.cos((float)(limbSwing * 0.6662f)) * 0.75f * limbSwingAmount;
            this.tailMid.zRot = this.tailBase.zRot + Mth.cos((float)(limbSwing * 0.6662f)) * 0.75f * limbSwingAmount;
            this.tailTop.setPos(0.0f - Mth.cos((float)(this.tailMid.zRot + 1.5707964f)) * 2.0f, 9.0f + (2.0f - Mth.sin((float)(this.tailMid.xRot + 1.5707964f)) * 2.0f), 3.5f - Mth.cos((float)(this.tailMid.xRot + 1.5707964f)) * 2.0f);
            this.tailTop.xRot = this.tailMid.xRot + Mth.cos((float)(limbSwing * 0.6662f)) * 1.75f * limbSwingAmount;
            this.tailTop.zRot = this.tailMid.xRot + Mth.cos((float)(limbSwing * 0.6662f)) * 1.75f * limbSwingAmount;
        }
        this.head.xRot = this.face.xRot;
        this.head.yRot = this.face.yRot;
    }

    public ModelPart root() {
        return this.root;
    }

    public void translateToHand(HumanoidArm side, PoseStack stack) {
        stack.translate(0.09375f, 0.1875f, 0.0f);
    }
}

