/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.tropicraft.core.common.entity.neutral.TreeFrogEntity;

public class TreeFrogModel
extends HierarchicalModel<TreeFrogEntity> {
    private final ModelPart root;
    private final ModelPart frontLeftLeg;
    private final ModelPart frontRightLeg;
    private final ModelPart rearRightLeg;
    private final ModelPart rearLeftLeg;

    public TreeFrogModel(ModelPart root) {
        this.root = root;
        this.frontLeftLeg = root.getChild("frontLeftLeg");
        this.frontRightLeg = root.getChild("frontRightLeg");
        this.rearRightLeg = root.getChild("rearRightLeg");
        this.rearLeftLeg = root.getChild("rearLeftLeg");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(12, 19).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)2.0f, (float)23.0f, (float)-3.0f));
        root.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(12, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)-2.0f, (float)23.0f, (float)-3.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 9.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)21.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("rearRightLeg", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)-2.0f, (float)19.0f, (float)4.0f));
        root.addOrReplaceChild("rearLeftLeg", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)2.0f, (float)19.0f, (float)4.0f));
        root.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)-1.0f, (float)19.0f, (float)-1.0f));
        root.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(0, 4).addBox(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)1.0f, (float)19.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(TreeFrogEntity froog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.frontLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rearLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rearRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.frontRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public ModelPart root() {
        return this.root;
    }
}

