/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.common.entity.passive.ToucanEntity;

public class ToucanModel
extends HierarchicalModel<ToucanEntity> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart legLeft;
    private final ModelPart legRight;
    private final ModelPart wingLeft;
    private final ModelPart wingRight;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart tailTop;
    private final ModelPart tailBottomLeft;
    private final ModelPart tailBottomRight;

    public ToucanModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body_base");
        this.legLeft = this.body.getChild("leg_left");
        this.legRight = this.body.getChild("leg_right");
        this.wingLeft = this.body.getChild("wing_left");
        this.wingRight = this.body.getChild("wing_right");
        this.neck = this.body.getChild("neck_base");
        this.head = this.neck.getChild("head_base");
        this.tailTop = this.body.getChild("tail_top");
        this.tailBottomLeft = this.body.getChild("tail_bottom_left");
        this.tailBottomRight = this.body.getChild("tail_bottom_right");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.5f, -4.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.0f, (float)2.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(5, 26).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.25f, (float)0.5f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(5, 24).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.25f, (float)0.5f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("wing_left", CubeListBuilder.create().texOffs(9, 12).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.5f, (float)-3.0f, (float)0.0f, (float)0.0436f, (float)0.0f));
        body.addOrReplaceChild("wing_right", CubeListBuilder.create().texOffs(0, 12).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.5f, (float)-3.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        body.addOrReplaceChild("tail_top", CubeListBuilder.create().texOffs(13, 7).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-0.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail_bottom_left", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-0.5f, (float)0.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail_bottom_right", CubeListBuilder.create().texOffs(13, 0).addBox(-2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-0.48f, (float)0.0f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck_base", CubeListBuilder.create().texOffs(9, 19).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.002f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-4.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head_base", CubeListBuilder.create().texOffs(0, 19).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.004f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        head.addOrReplaceChild("beak_top", CubeListBuilder.create().texOffs(0, 24).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        head.addOrReplaceChild("beak_bottom", CubeListBuilder.create().texOffs(16, 19).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(ToucanEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        this.neck.xRot = (headPitch - 65.0f) * ((float)Math.PI / 180);
        this.head.zRot = headYaw * ((float)Math.PI / 180);
        float partialTicks = ageInTicks - (float)entity.tickCount;
        float flightAnimation = entity.getFlightAnimation(partialTicks);
        float walkAnimation = 1.0f - flightAnimation;
        if (flightAnimation > 0.0f) {
            this.body.xRot += 0.43633232f * flightAnimation;
            this.head.xRot -= 0.43633232f * flightAnimation;
            this.tailTop.xRot -= 0.61086524f * flightAnimation;
            this.tailBottomLeft.xRot -= 0.6981317f * flightAnimation;
            this.tailBottomRight.xRot -= 0.6981317f * flightAnimation;
            this.tailBottomLeft.yRot += 0.61086524f * flightAnimation;
            this.tailBottomRight.yRot -= 0.61086524f * flightAnimation;
            this.legLeft.xRot += 0.6981317f * flightAnimation;
            this.legRight.xRot += 0.6981317f * flightAnimation;
            this.wingLeft.xRot += 1.5707964f * flightAnimation;
            this.wingRight.xRot += 1.5707964f * flightAnimation;
            try (ModelAnimator.Cycle fly = ModelAnimator.cycle(ageInTicks * 0.15f, flightAnimation);){
                this.body.y += fly.eval(1.0f, 0.2f, 0.06f, 0.0f);
                this.body.xRot += fly.eval(1.0f, -0.04f, 0.06f, -0.04f);
                this.tailTop.xRot += fly.eval(1.0f, 0.1f, -0.2f, 0.0f);
                this.tailBottomLeft.xRot += fly.eval(1.0f, 0.1f, -0.1f, 0.0f);
                this.tailBottomRight.xRot += fly.eval(1.0f, 0.1f, -0.1f, 0.0f);
                this.wingLeft.zRot += fly.eval(1.0f, 1.3f, -0.1f, 1.4f);
                this.wingRight.zRot += fly.eval(1.0f, -1.3f, -0.1f, -1.4f);
            }
        }
        if (walkAnimation > 0.0f) {
            try (ModelAnimator.Cycle walk = ModelAnimator.cycle(limbSwing, limbSwingAmount * walkAnimation);){
                this.legLeft.xRot += walk.eval(1.0f, 1.0f);
                this.legRight.xRot += walk.eval(1.0f, -1.0f);
            }
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

