/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.common.entity.underdasea.EagleRayEntity;

public class EagleRayModel
extends HierarchicalModel<EagleRayEntity> {
    private final float[] interpolatedWingAmplitudes = new float[10];
    private final ModelPart root;

    public EagleRayModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(-2.0f, 0.0f, 0.0f, 5.0f, 3.0f, 32.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(EagleRayEntity eagleRay, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        super.renderToBuffer(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.renderWings(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.renderTailSimple(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    private void renderTailSimple(PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, int color) {
        float minU = 0.75f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 0.5f;
        stack.pushPose();
        stack.translate(0.55f, 0.0f, 1.5f);
        stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        stack.scale(1.5f, 1.0f, 1.0f);
        EagleRayModel.vertex(buffer, stack.last(), 0.0f, 0.0f, 0.0f, color, minU, minV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.last(), 0.0f, 0.0f, 1.0f, color, minU, maxV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.last(), 1.0f, 0.0f, 1.0f, color, maxU, maxV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.last(), 1.0f, 0.0f, 0.0f, color, maxU, minV, packedLightIn, packedOverlayIn);
        stack.popPose();
    }

    private static void vertex(VertexConsumer bufferIn, PoseStack.Pose pose, float x, float y, float z, int color, float texU, float texV, int packedLight, int packedOverlay) {
        bufferIn.addVertex(pose, x, y, z).setColor(color).setUv(texU, texV).setOverlay(packedOverlay).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
    }

    private void renderWings(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.03125f, 0.0f, -0.5f);
        matrixStackIn.scale(2.0f, 0.5f, 2.0f);
        this.renderWing(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color, false);
        matrixStackIn.translate(0.0f, 0.0f, 0.5f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStackIn.translate(0.0f, 0.0f, -0.5f);
        this.renderWing(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color, true);
        matrixStackIn.popPose();
    }

    private void renderWing(PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, int color, boolean reverse) {
        float minUFront = 0.0f;
        float maxUFront = 0.25f;
        float minVFront = 0.0f;
        float maxVFront = 0.5f;
        float minUBack = 0.0f;
        float maxUBack = 0.25f;
        float minVBack = 0.5f;
        float maxVBack = 1.0f;
        stack.pushPose();
        stack.translate(0.078125f, 0.0f, 0.0f);
        for (int i = 1; i < 10; ++i) {
            float prevAmplitude = this.interpolatedWingAmplitudes[i - 1];
            float amplitude = this.interpolatedWingAmplitudes[i];
            float prevX = (float)(i - 1) / 9.0f;
            float x = (float)i / 9.0f;
            float prevUFront = minUFront + (maxUFront - minUFront) * prevX;
            float uFront = minUFront + (maxUFront - minUFront) * x;
            float prevUBack = minUBack + (maxUBack - minUBack) * prevX;
            float uBack = minUBack + (maxUBack - minUBack) * x;
            float offset = -0.001f;
            PoseStack.Pose pose = stack.last();
            EagleRayModel.vertex(buffer, pose, x, amplitude - offset, 0.0f, color, uBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, pose, x, amplitude - offset, 1.0f, color, uBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, pose, prevX, prevAmplitude - offset, 1.0f, color, prevUBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, pose, prevX, prevAmplitude - offset, 0.0f, color, prevUBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, pose, prevX, prevAmplitude, 0.0f, color, prevUFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, pose, prevX, prevAmplitude, 1.0f, color, prevUFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, pose, x, amplitude, 1.0f, color, uFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, pose, x, amplitude, 0.0f, color, uFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
        }
        stack.popPose();
    }

    public void prepareMobModel(EagleRayEntity ray, float par2, float par3, float partialTicks) {
        float[] prevWingAmplitudes = ray.getPrevWingAmplitudes();
        float[] wingAmplitudes = ray.getWingAmplitudes();
        for (int i = 1; i < 10; ++i) {
            float prevWingAmplitude = prevWingAmplitudes[i];
            float wingAmplitude = wingAmplitudes[i];
            this.interpolatedWingAmplitudes[i] = prevWingAmplitude + partialTicks * (wingAmplitude - prevWingAmplitude);
        }
    }
}

