/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.tropicraft.Tropicraft;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="tropicraft", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FaceItemGeometryLoader
implements IGeometryLoader<Geometry> {
    public static final FaceItemGeometryLoader INSTANCE = new FaceItemGeometryLoader();
    public static final ResourceLocation ID = Tropicraft.location("face_item");

    @SubscribeEvent
    public static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ID, (IGeometryLoader)INSTANCE);
    }

    public Geometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        BlockModel itemModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"item"), BlockModel.class);
        BlockModel equippedModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"equipped"), BlockModel.class);
        return new Geometry(itemModel, equippedModel);
    }

    public record Geometry(BlockModel itemModel, BlockModel equippedModel) implements IUnbakedGeometry<Geometry>
    {
        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            return new Baked(this.itemModel.bake(baker, this.itemModel, spriteGetter, modelState, context.useBlockLight()), this.equippedModel.bake(baker, this.equippedModel, spriteGetter, modelState, context.useBlockLight()));
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.itemModel.resolveParents(modelGetter);
            this.equippedModel.resolveParents(modelGetter);
        }
    }

    private record Baked(BakedModel itemModel, BakedModel equippedModel) implements IDynamicBakedModel
    {
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            return this.itemModel.getQuads(state, side, rand, extraData, renderType);
        }

        public boolean useAmbientOcclusion() {
            return this.itemModel.useAmbientOcclusion();
        }

        public boolean isGui3d() {
            return this.itemModel.isGui3d();
        }

        public boolean usesBlockLight() {
            return this.itemModel.usesBlockLight();
        }

        public boolean isCustomRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.itemModel.getParticleIcon();
        }

        public ItemOverrides getOverrides() {
            return this.itemModel.getOverrides();
        }

        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            BakedModel model = cameraTransformType == ItemDisplayContext.HEAD ? this.equippedModel : this.itemModel;
            return model.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return this.itemModel.getRenderTypes(state, rand, data);
        }
    }
}

