/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.neoforgespi.locating.IModFile;
import org.slf4j.Logger;

public class EmbeddedPackSource
implements RepositorySource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final IModFile modFile;
    private final PackType type;
    private final Component packName;
    private final String packId;

    public EmbeddedPackSource(IModFile modFile, PackType type, String packId, Component packName) {
        this.modFile = modFile;
        this.type = type;
        this.packId = packId;
        this.packName = packName;
    }

    public void loadPacks(Consumer<Pack> consumer) {
        PackSelectionConfig selectionConfig;
        PathPackResources.PathResourcesSupplier resourcesSupplier;
        Path packPath = this.modFile.findResource(new String[]{this.type == PackType.CLIENT_RESOURCES ? "resourcepacks" : "datapacks"}).resolve(this.packId);
        if (!Files.exists(packPath, new LinkOption[0])) {
            LOGGER.error("Unable to find embedded mod pack {} at {}", (Object)this.packId, (Object)packPath);
            return;
        }
        PackLocationInfo locationInfo = new PackLocationInfo(this.packId, this.packName, PackSource.BUILT_IN, Optional.empty());
        Pack pack = Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)(resourcesSupplier = new PathPackResources.PathResourcesSupplier(packPath)), (PackType)this.type, (PackSelectionConfig)(selectionConfig = new PackSelectionConfig(false, Pack.Position.TOP, false)));
        if (pack != null) {
            consumer.accept(pack);
        }
    }
}

