/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import io.github.mortuusars.horseman.Horseman;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import org.jetbrains.annotations.Nullable;

public record BoundData(UUID owner, ResourceKey<Instrument> instrument) {
    public BoundData(Player player, ResourceKey<Instrument> instrument) {
        this(player.getUUID(), instrument);
    }

    public boolean isBoundTo(UUID uuid) {
        return this.owner().equals(uuid);
    }

    public boolean isBoundTo(Player player) {
        return this.isBoundTo(player.getUUID());
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putUUID("HorsemanCallingOwner", this.owner);
        tag.putString("HorsemanCallingInstrument", this.instrument.location().toString());
        return tag;
    }

    @Nullable
    public static BoundData load(CompoundTag tag) {
        if (!tag.contains("HorsemanCallingOwner", 11)) {
            return null;
        }
        if (!tag.contains("HorsemanCallingInstrument", 8)) {
            return null;
        }
        return new BoundData(tag.getUUID("HorsemanCallingOwner"), BoundData.getResourceKey1(tag, "HorsemanCallingInstrument", Registries.INSTRUMENT));
    }

    private static <T> ResourceKey<T> getResourceKey1(CompoundTag tag, String key, ResourceKey<Registry<T>> registry) {
        String string = tag.getString(key);
        try {
            return ResourceKey.create(registry, (ResourceLocation)ResourceLocation.parse((String)string));
        }
        catch (Exception e) {
            Horseman.LOGGER.error("Cannot parse '{}' from '{}'.", new Object[]{key, string, e});
            return null;
        }
    }
}

