/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world;

import io.github.mortuusars.horseman.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class HorseStepDown {
    public static boolean shouldHorseStepDown(AbstractHorse horse) {
        if (!((Boolean)Config.Server.HORSE_FAST_STEP_DOWN.get()).booleanValue()) {
            return false;
        }
        if (!(horse.getControllingPassenger() instanceof Player)) {
            return false;
        }
        if (horse.onGround() || horse.isJumping()) {
            return false;
        }
        return (double)horse.fallDistance > 0.0 && (double)horse.fallDistance < 0.2 && HorseStepDown.canStepDownOnBlock(horse);
    }

    private static boolean canStepDownOnBlock(AbstractHorse horse) {
        BlockPos pos;
        Level level = horse.level();
        if (!level.getBlockState((pos = horse.blockPosition()).below()).getCollisionShape((BlockGetter)level, pos.below()).isEmpty()) {
            return true;
        }
        return (Boolean)Config.Server.HORSE_FAST_STEP_DOWN_TWO_BLOCKS.get() != false && !level.getBlockState(pos.below(2)).getCollisionShape((BlockGetter)level, pos.below(2)).isEmpty();
    }
}

