/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.network.Packets;
import io.github.mortuusars.horseman.network.packet.client.SyncHorseDataS2CP;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface HitchableHorse {
    public ItemStack horseman$getLead();

    public void horseman$setLead(ItemStack var1);

    public boolean horseman$isHitched();

    public void horseman$setHitched(boolean var1);

    public Container horseman$getLeadAccess();

    default public boolean horseman$hasLead() {
        return !this.horseman$getLead().isEmpty();
    }

    default public AbstractHorse horseman$asHorse() {
        return (AbstractHorse)this;
    }

    public static boolean isEnabled() {
        return (Boolean)Config.Server.HORSE_HITCH.get();
    }

    public static boolean requiresLead() {
        return (Boolean)Config.Server.HORSE_HITCH_REQUIRES_LEAD.get();
    }

    public static boolean isHitchable(HitchableHorse horse) {
        return horse.horseman$asHorse().isTamed() && !horse.horseman$asHorse().isBaby() && !horse.horseman$asHorse().getType().is(Horseman.Tags.EntityTypes.CANNOT_BE_HITCHED);
    }

    public static boolean canHitch(HitchableHorse horse) {
        return HitchableHorse.isEnabled() && HitchableHorse.isHitchable(horse) && !horse.horseman$asHorse().isLeashed() && (!HitchableHorse.requiresLead() || HitchableHorse.hasLead(horse));
    }

    public static boolean isHitched(HitchableHorse horse) {
        return horse.horseman$isHitched();
    }

    public static void setHitched(HitchableHorse horse, boolean hitched) {
        horse.horseman$setHitched(hitched);
    }

    public static ItemStack getLead(HitchableHorse horse) {
        return horse.horseman$getLead();
    }

    public static void setLead(HitchableHorse horse, ItemStack leadStack) {
        horse.horseman$setLead(leadStack);
    }

    public static boolean hasLead(HitchableHorse horse) {
        return horse.horseman$hasLead();
    }

    public static boolean shouldHaveLeadSlot(HitchableHorse horse) {
        return HitchableHorse.isEnabled() && HitchableHorse.requiresLead() && (Boolean)Config.Server.HORSE_HITCH_INVENTORY_SLOT.get() != false && HitchableHorse.isHitchable(horse);
    }

    public static boolean mayPlaceInLeadSlot(HitchableHorse horse, ItemStack stack) {
        return stack.is(Items.LEAD);
    }

    public static boolean isLeadSlotActive(HitchableHorse horse) {
        return !HitchableHorse.isHitched(horse);
    }

    public static void syncHorseDataToClient(HitchableHorse horse, ServerPlayer player) {
        Packets.sendToClient(new SyncHorseDataS2CP(horse.horseman$asHorse().getId(), HitchableHorse.getLead(horse), HitchableHorse.isHitched(horse)), player);
    }

    public static void syncHorseDataToTrackingClients(HitchableHorse horse) {
        Packets.sendToPlayersTrackingEntity((Entity)horse.horseman$asHorse(), new SyncHorseDataS2CP(horse.horseman$asHorse().getId(), HitchableHorse.getLead(horse), HitchableHorse.isHitched(horse)));
    }
}

