/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.neoforge;

import com.google.common.base.Preconditions;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.neoforge.HorsemanNeoForgeClient;
import io.github.mortuusars.horseman.neoforge.RegisterImpl;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

@Mod(value="horseman")
public class HorsemanNeoForge {
    public HorsemanNeoForge(ModContainer container) {
        Horseman.init();
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.Server.SPEC);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.Common.SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.Client.SPEC);
        @Nullable IEventBus modEventBus = container.getEventBus();
        Preconditions.checkNotNull((Object)modEventBus);
        RegisterImpl.BLOCKS.register(modEventBus);
        RegisterImpl.BLOCK_ENTITY_TYPES.register(modEventBus);
        RegisterImpl.ENTITY_TYPES.register(modEventBus);
        RegisterImpl.ITEMS.register(modEventBus);
        RegisterImpl.MENU_TYPES.register(modEventBus);
        RegisterImpl.RECIPE_TYPES.register(modEventBus);
        RegisterImpl.RECIPE_SERIALIZERS.register(modEventBus);
        RegisterImpl.CRITERION_TRIGGERS.register(modEventBus);
        RegisterImpl.ITEM_SUB_PREDICATES.register(modEventBus);
        RegisterImpl.SOUND_EVENTS.register(modEventBus);
        RegisterImpl.COMMAND_ARGUMENT_TYPES.register(modEventBus);
        RegisterImpl.WORLD_GEN_FEATURES.register(modEventBus);
        RegisterImpl.DATA_COMPONENT_TYPES.register(modEventBus);
        RegisterImpl.PARTICLE_TYPES.register(modEventBus);
        RegisterImpl.CUSTOM_STATS.register(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            HorsemanNeoForgeClient.init(container);
        }
    }
}

