/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Leashable.class})
public interface LeashableMixin {
    @Inject(method={"dropLeash(Lnet/minecraft/world/entity/Entity;ZZ)V"}, at={@At(value="HEAD")})
    private static <E extends Entity> void onDropLeash(E entity, boolean broadcastPacket, boolean dropItem, CallbackInfo ci, @Share(value="preventDrop") LocalBooleanRef preventDrop) {
        if (!(entity instanceof HitchableHorse)) {
            return;
        }
        HitchableHorse horse = (HitchableHorse)entity;
        boolean hitched = HitchableHorse.isHitched(horse);
        HitchableHorse.setHitched(horse, false);
        if (!entity.level().isClientSide) {
            HitchableHorse.syncHorseDataToTrackingClients(horse);
        }
        preventDrop.set(hitched);
    }

    @WrapWithCondition(method={"dropLeash(Lnet/minecraft/world/entity/Entity;ZZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;spawnAtLocation(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/entity/item/ItemEntity;")})
    private static boolean preventLeadDrop(Entity entity, ItemLike item, @Share(value="preventDrop") LocalBooleanRef preventDrop) {
        return !preventDrop.get();
    }
}

