/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceBlock.class})
public class FenceBlockMixin {
    @Inject(method={"useItemOn(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/ItemInteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<ItemInteractionResult> cir) {
        HitchableHorse hitchableHorse;
        AbstractHorse horse;
        Entity entity;
        if (level.isClientSide && (entity = player.getRootVehicle()) instanceof AbstractHorse && (horse = (AbstractHorse)entity) instanceof HitchableHorse && HitchableHorse.canHitch(hitchableHorse = (HitchableHorse)horse)) {
            cir.setReturnValue((Object)ItemInteractionResult.SUCCESS);
        }
    }

    @Inject(method={"useWithoutItem(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        HitchableHorse hitchableHorse;
        AbstractHorse horse;
        Entity entity = player.getRootVehicle();
        if (entity instanceof AbstractHorse && (horse = (AbstractHorse)entity) instanceof HitchableHorse && HitchableHorse.canHitch(hitchableHorse = (HitchableHorse)horse)) {
            horse.setLeashedTo((Entity)player, true);
            HitchableHorse.setHitched(hitchableHorse, true);
            if (!level.isClientSide) {
                InteractionResult result = LeadItem.bindPlayerMobs((Player)player, (Level)level, (BlockPos)pos);
                HitchableHorse.syncHorseDataToTrackingClients(hitchableHorse);
                cir.setReturnValue((Object)result);
            } else {
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
        }
    }
}

