/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.world.HitchableHorse;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements HitchableHorse {
    @Unique
    protected final Container horseman$leadAccess = AbstractHorseMixin.horseman$createLeadAccess(this.horseman$asHorse());
    @Unique
    protected ItemStack horseman$leadItem = ItemStack.EMPTY;
    @Unique
    protected boolean horseman$isHitched = false;

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public ItemStack horseman$getLead() {
        return this.horseman$leadItem;
    }

    @Override
    public void horseman$setLead(ItemStack stack) {
        this.horseman$leadItem = stack;
    }

    @Override
    public boolean horseman$isHitched() {
        return this.isLeashed() && this.horseman$isHitched;
    }

    @Override
    public void horseman$setHitched(boolean hitched) {
        this.horseman$isHitched = hitched;
    }

    @Override
    public Container horseman$getLeadAccess() {
        return this.horseman$leadAccess;
    }

    @Inject(method={"dropEquipment()V"}, at={@At(value="RETURN")})
    private void onDropEquipment(CallbackInfo ci) {
        if (HitchableHorse.hasLead(this)) {
            this.spawnAtLocation(HitchableHorse.getLead(this));
            HitchableHorse.setLead(this, ItemStack.EMPTY);
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    protected void onAddAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        ItemStack leadStack = this.horseman$getLead();
        if (!leadStack.isEmpty()) {
            tag.put("HorsemanLeadItem", leadStack.save((HolderLookup.Provider)this.registryAccess()));
        }
        if (this.horseman$isHitched()) {
            tag.putBoolean("HorsemanHitched", true);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    protected void onReadAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.contains("HorsemanLeadItem", 10)) {
            ItemStack leadStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)tag.getCompound("HorsemanLeadItem")).orElse(ItemStack.EMPTY);
            this.horseman$setLead(leadStack);
        }
        this.horseman$isHitched = tag.getBoolean("HorsemanHitched");
    }

    @Unique
    private static Container horseman$createLeadAccess(final AbstractHorse horse) {
        return new ContainerSingleItem(){
            private final AbstractHorse ownerHorse;
            {
                this.ownerHorse = horse;
            }

            @NotNull
            public ItemStack getTheItem() {
                return ((HitchableHorse)horse).horseman$getLead();
            }

            public void setTheItem(ItemStack item) {
                ((HitchableHorse)horse).horseman$setLead(item);
            }

            public void setChanged() {
            }

            public boolean stillValid(Player player) {
                return player.getVehicle() == this.ownerHorse || player.canInteractWithEntity((Entity)this.ownerHorse, 4.0);
            }
        };
    }
}

