/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.fix_running_back;

import io.github.mortuusars.horseman.Config;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class}, priority=950)
public abstract class EntityMixin {
    @Shadow
    public abstract Level level();

    @Shadow
    @Nullable
    public abstract Entity getVehicle();

    @Inject(method={"removeVehicle()V"}, at={@At(value="HEAD")})
    private void removeVehicle(CallbackInfo ci) {
        AbstractHorse horse;
        Entity entity;
        if (((Boolean)Config.Server.FIX_RUNNING_BACK_AFTER_DISMOUNT.get()).booleanValue() && (entity = this.getVehicle()) instanceof AbstractHorse && (horse = (AbstractHorse)entity).getPassengers().size() == 1) {
            horse.getNavigation().stop();
        }
    }
}

