/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.kyanite.deeperdarker.content.entities.Stalker;
import com.kyanite.deeperdarker.content.entities.animations.StalkerAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class StalkerModel
extends HierarchicalModel<Stalker> {
    private final ModelPart root;
    private final ModelPart head;

    public StalkerModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("root").getChild("waist").getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition root = parts.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition waist = root.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(18, 46).addBox(-6.5f, -2.0f, -3.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(44, 46).addBox(0.5f, -2.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-29.0f, (float)0.5f));
        PartDefinition body = waist.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        body.addOrReplaceChild("body_top", CubeListBuilder.create().texOffs(24, 9).addBox(-7.0f, -4.0f, -3.5f, 14.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        body.addOrReplaceChild("body_right", CubeListBuilder.create().texOffs(24, 20).addBox(-3.0f, -4.5f, -3.5f, 3.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-7.5f, (float)0.0f));
        body.addOrReplaceChild("body_left", CubeListBuilder.create().texOffs(44, 20).addBox(0.0f, -4.5f, -3.5f, 3.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-7.5f, (float)0.0f));
        body.addOrReplaceChild("body_bottom", CubeListBuilder.create().texOffs(24, 36).addBox(-7.0f, 0.0f, -3.5f, 14.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -24.0f, -3.0f, 6.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-16.0f, (float)0.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(24, 0).addBox(-4.98f, -2.5f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.02f, (float)-18.5f, (float)0.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(42, 1).addBox(-0.02f, -2.5f, -1.5f, 5.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.02f, (float)-16.5f, (float)0.0f));
        PartDefinition arms = body.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        arms.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 30).addBox(-4.0f, 0.0f, -2.0f, 4.0f, 31.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)0.0f, (float)-0.5f));
        arms.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 66).addBox(0.0f, -2.0f, -2.5f, 5.0f, 22.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)0.0f, (float)0.0f));
        PartDefinition teeth = body.addOrReplaceChild("teeth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.5f, (float)-3.5f));
        teeth.addOrReplaceChild("upper_right_tooth", CubeListBuilder.create().texOffs(66, 2).addBox(-1.3536f, -1.1465f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.3964f, (float)-5.6035f, (float)0.0f));
        teeth.addOrReplaceChild("upper_left_tooth", CubeListBuilder.create().texOffs(80, 0).addBox(-1.3536f, -0.8535f, -7.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.1036f, (float)-4.8965f, (float)0.0f));
        teeth.addOrReplaceChild("lower_right_tooth", CubeListBuilder.create().texOffs(66, 9).addBox(-1.0f, -1.0f, -7.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.75f, (float)5.25f, (float)0.0f));
        teeth.addOrReplaceChild("lower_left_tooth", CubeListBuilder.create().texOffs(84, 9).addBox(-1.0f, -1.5f, -6.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.75f, (float)5.25f, (float)0.0f));
        PartDefinition back = body.addOrReplaceChild("back", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)31.0f, (float)-0.5f));
        back.addOrReplaceChild("upper_back", CubeListBuilder.create().texOffs(68, 18).addBox(-2.5f, -1.0f, 0.0f, 5.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-44.5f, (float)4.0f));
        back.addOrReplaceChild("middle_back", CubeListBuilder.create().texOffs(68, 29).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-38.0f, (float)4.0f));
        back.addOrReplaceChild("lower_back", CubeListBuilder.create().texOffs(68, 44).addBox(-2.0f, -1.5f, 0.0f, 4.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)-33.5f, (float)4.0f));
        back.addOrReplaceChild("vase", CubeListBuilder.create().texOffs(72, 58).addBox(-4.0f, -16.0f, -3.9167f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(64, 69).addBox(-6.0f, -13.0f, -5.9167f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(68, 93).addBox(-5.0f, -1.0f, -4.9167f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-38.5f, (float)15.4167f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition legs = waist.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        legs.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 54).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 29.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)0.0f, (float)0.0f));
        legs.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(44, 55).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(Stalker entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(StalkerAnimation.WALK, limbSwing, limbSwingAmount, 3.0f, 2.5f);
        this.animate(entity.idleState, StalkerAnimation.IDLE, ageInTicks);
        this.animate(entity.attackState, StalkerAnimation.ATTACK, ageInTicks);
        this.animate(entity.ringAttackState, StalkerAnimation.RING_ATTACK, ageInTicks);
        this.animate(entity.emergeState, StalkerAnimation.EMERGE, ageInTicks);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.getChild("root").render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

