/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.storagenopoof;

import com.matyrobbrt.storagenopoof.PreserverBlock;
import com.matyrobbrt.storagenopoof.PreserverBlockEntity;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

@Mod(value="storagenopoof")
public class StorageNoPoof {
    public static final String MOD_ID = "storagenopoof";
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"storagenopoof");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"storagenopoof");
    public static final DeferredBlock<Block> PRESERVER = BLOCKS.register("preserver", () -> new PreserverBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(0.2f)));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PreserverBlockEntity>> PRESERVER_BE = BLOCK_ENTITIES.register("preserver", () -> BlockEntityType.Builder.of(PreserverBlockEntity::new, (Block[])new Block[]{(Block)PRESERVER.get()}).build(null));

    public StorageNoPoof(IEventBus bus) {
        BLOCKS.register(bus);
        BLOCK_ENTITIES.register(bus);
        bus.addListener(event -> event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)PRESERVER_BE.get(), (object, context) -> object.handler));
        bus.addListener(event -> {
            event.getGenerator().addProvider(event.includeClient(), (DataProvider)new BlockStateProvider(this, event.getGenerator().getPackOutput(), MOD_ID, event.getExistingFileHelper()){

                protected void registerStatesAndModels() {
                    this.simpleBlock((Block)PRESERVER.value());
                }
            });
            event.getGenerator().addProvider(event.includeClient(), (DataProvider)new LanguageProvider(this, event.getGenerator().getPackOutput(), MOD_ID, "en_us"){

                protected void addTranslations() {
                    this.addBlock((Supplier)PRESERVER, "Preserver");
                }
            });
        });
    }

    @Nullable
    public static BlockEntity attemptToPreserveInventories(BlockPos pos, BlockState state, CompoundTag tag, HolderLookup.Provider registries, Level level, @Nullable LevelChunk chunk) {
        List<ItemStack> preservation;
        BlockEntityType type;
        ResourceLocation id;
        if (state.isAir() && (id = ResourceLocation.tryParse((String)tag.getString("id"))) != null && (type = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(id)) == null && (preservation = StorageNoPoof.attemptPreservation(id, tag, registries)) != null) {
            BlockState newState = ((Block)PRESERVER.get()).defaultBlockState();
            if (chunk != null) {
                chunk.setBlockState(pos, newState, false);
            } else {
                level.setBlock(pos, newState, 3);
            }
            PreserverBlockEntity be = new PreserverBlockEntity(pos, newState);
            be.loadItems(preservation);
            be.originalTag = tag;
            return be;
        }
        return null;
    }

    @Nullable
    public static List<ItemStack> attemptPreservation(ResourceLocation beId, CompoundTag rootTag, HolderLookup.Provider registries) {
        if (rootTag.contains("Items", 9)) {
            int size = rootTag.getList("Items", 10).size();
            NonNullList inv = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)rootTag, (NonNullList)inv, (HolderLookup.Provider)registries);
            return inv;
        }
        return null;
    }
}

