/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.storagenopoof;

import com.matyrobbrt.storagenopoof.StorageNoPoof;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PreserverBlockEntity
extends BlockEntity {
    public static final String TAG_ID = "PreservedItems";
    public static final String ORIGINAL_TAG_ID = "OriginalTag";
    public final ItemStackHandler handler = new ItemStackHandler(){

        protected void onContentsChanged(int slot) {
            PreserverBlockEntity.this.setChanged();
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).isEmpty()) continue;
                return;
            }
            if (PreserverBlockEntity.this.level != null) {
                PreserverBlockEntity.this.level.setBlock(PreserverBlockEntity.this.worldPosition, Blocks.AIR.defaultBlockState(), 3);
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    public CompoundTag originalTag = new CompoundTag();

    public PreserverBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)StorageNoPoof.PRESERVER_BE.get(), pos, blockState);
    }

    public void loadItems(List<ItemStack> stack) {
        this.handler.setSize(stack.size());
        for (int i = 0; i < stack.size(); ++i) {
            this.handler.setStackInSlot(i, stack.get(i).copy());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(TAG_ID)) {
            this.handler.deserializeNBT(registries, tag.getCompound(TAG_ID));
        }
        if (tag.contains(ORIGINAL_TAG_ID)) {
            this.originalTag = tag.getCompound(ORIGINAL_TAG_ID);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(TAG_ID, (Tag)this.handler.serializeNBT(registries));
        tag.put(ORIGINAL_TAG_ID, (Tag)this.originalTag);
    }
}

