/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.oretap;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.core.utils.rules.BlockRule;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.content.recipes.producers.oretap.OreTapRecipe;

public class OreTapRecipeBuilder
implements IRecipeBuilder.WithItem.Output<OreTapRecipeBuilder, OreTapRecipe>,
IRecipeBuilder.WithFluid.Output<OreTapRecipeBuilder, OreTapRecipe>,
IRecipeBuilder.WithStage<OreTapRecipeBuilder, OreTapRecipe> {
    private IRule _rule;
    private Either<FluidStack, ItemStack> _output = null;
    private long _ticks;
    private Optional<IStage> _requiredStage = Optional.empty();

    public static OreTapRecipeBuilder create() {
        return (OreTapRecipeBuilder)new OreTapRecipeBuilder().seconds(5L);
    }

    public OreTapRecipeBuilder input(IRule rule) {
        this._rule = rule;
        return this;
    }

    public OreTapRecipeBuilder input(Block block) {
        this._rule = new BlockRule(block);
        return this;
    }

    public OreTapRecipeBuilder output(FluidStack outputIngredient) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Ore Tap Recipe!");
        }
        this._output = Either.left((Object)outputIngredient);
        return this;
    }

    public OreTapRecipeBuilder output(ItemStack outputIngredient) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Ore Tap Recipe!");
        }
        this._output = Either.right((Object)outputIngredient);
        return this;
    }

    @NotNull
    public OreTapRecipeBuilder ticks(long ticks) {
        this._ticks = ticks;
        return this;
    }

    @NotNull
    public OreTapRecipe makeRecipe() {
        return new OreTapRecipe(this._rule, this._output, this._ticks, this._requiredStage);
    }

    public void ensureValid(String id) {
        if (this._rule == null) {
            throw new RuntimeException("Node Target is null in Ore Tap recipe - " + id);
        }
        if (this._output == null) {
            throw new RuntimeException("No output in Ore Tap recipe - " + id);
        }
        if (this._ticks <= 0L) {
            throw new RuntimeException("No ticks in Ore Tap recipe - " + id);
        }
    }

    @NotNull
    public OreTapRecipeBuilder requires(IStage stage) {
        this._requiredStage = Optional.of(stage);
        return this;
    }
}

