/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.IdMapper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.GameData;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.utils.StreamUtils;
import tv.soaryn.xycraft.core.utils.profiler.ProfileMarker;
import tv.soaryn.xycraft.core.utils.rules.FluidRuleGroup;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public final class ExtractorViewerCommon {
    public static final ConcurrentHashMap<IRule, Set<BlockState>> RuleToBlockState = new ConcurrentHashMap();
    public static final ConcurrentHashMap<IRule, List<ItemStack>> RuleToItems = new ConcurrentHashMap();
    public static final ConcurrentHashMap<IRule, List<FluidStack>> RuleToFluids = new ConcurrentHashMap();
    private static final ProfileMarker MarkerRegister = ProfileMarker.of((String)"JEI Integration");
    private static final ProfileMarker MarkerRecipeManagerAccess = ProfileMarker.of((String)"RecipeManagerAccess");
    private static final ProfileMarker MarkerSortingRecipes = ProfileMarker.of((String)"SortRecipes");
    private static final ProfileMarker MarkerAccessBlockStateMap = ProfileMarker.of((String)"AccessBlockStates");
    private static final ProfileMarker MarkerMapRules = ProfileMarker.of((String)"MappingRules");
    private static final ProfileMarker MarkerWaiting = ProfileMarker.of((String)"Main Thread Idle Time");
    private static final ProfileMarker MarkerRegisterRecipes = ProfileMarker.of((String)"JEI Internals - Add Recipe");

    private ExtractorViewerCommon() {
    }

    public static void handleIntegration(BiConsumer<List<RecipeHolder<ExtractorRecipe>>, List<RecipeHolder<ExtractorRecipe>>> handleItemAndFluidList) {
        RuleToBlockState.clear();
        RuleToItems.clear();
        RuleToFluids.clear();
        assert (Minecraft.getInstance().level != null);
        MarkerRegister.begin();
        MarkerAccessBlockStateMap.begin();
        IdMapper idMap = GameData.getBlockStateIDMap();
        ArrayList blockStates = new ArrayList();
        idMap.forEach(blockStates::add);
        MarkerAccessBlockStateMap.end();
        MarkerRecipeManagerAccess.begin();
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList<RecipeHolder> list = new ArrayList<RecipeHolder>();
        List allExtractorRecipes = manager.getAllRecipesFor((RecipeType)MachinesRecipeTypes.Extractor.type().get());
        for (RecipeHolder holder2 : allExtractorRecipes) {
            ExtractorRecipe recipe = (ExtractorRecipe)holder2.value();
            if (recipe.hidden() && !XyCore.ClientConfig.ShowHiddenRecipes.getAsBoolean()) continue;
            list.add(holder2);
        }
        MarkerRecipeManagerAccess.end();
        List<ExtractorRecipe> recipeValueList = list.stream().map(RecipeHolder::value).toList();
        Thread thread = new Thread(() -> {
            MarkerMapRules.begin();
            StreamUtils.execute(() -> recipeValueList.parallelStream().flatMap(recipe -> recipe.getAllRules().stream()).distinct().forEach(unique -> {
                Set matchedStates = blockStates.parallelStream().filter(arg_0 -> ((IRule)unique).matches(arg_0)).collect(Collectors.toSet());
                RuleToBlockState.put((IRule)unique, matchedStates);
                if (unique instanceof FluidRuleGroup) {
                    RuleToFluids.put((IRule)unique, matchedStates.stream().map(state -> state.getFluidState().getType()).filter(ExtractorViewerCommon.distinctPredicate(Fluid::getFluidType)).distinct().map(state -> new FluidStack(state, 1000)).distinct().toList());
                } else {
                    RuleToItems.put((IRule)unique, matchedStates.stream().map(state -> new ItemStack((ItemLike)state.getBlock())).toList());
                }
            }));
            MarkerMapRules.end();
        });
        thread.setName("RuleMapper");
        thread.start();
        MarkerSortingRecipes.begin();
        List<RecipeHolder> itemList = list.stream().filter(holder -> !((ExtractorRecipe)holder.value()).isFluidRecipe()).sorted(ExtractorViewerCommon::compareItemResults).toList();
        List<RecipeHolder> fluidList = list.stream().filter(holder -> ((ExtractorRecipe)holder.value()).isFluidRecipe()).sorted(ExtractorViewerCommon::compareFluidResults).toList();
        MarkerSortingRecipes.end();
        try {
            MarkerWaiting.begin();
            thread.join();
            MarkerWaiting.end();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int ruleCount = RuleToBlockState.size();
        int blockStateCount = blockStates.size();
        MarkerRegisterRecipes.begin();
        handleItemAndFluidList.accept(itemList, fluidList);
        MarkerRegisterRecipes.end();
        blockStates.clear();
        MarkerRegister.end();
        XyMachines.Logger.debug("------------------------------------------------------------------------");
        XyMachines.Logger.debug("----- Extractor Ingredient Integration Breakdown:");
        XyMachines.Logger.debug("----- BlockState Count: " + blockStateCount);
        XyMachines.Logger.debug("----- Rule Count: " + ruleCount);
        XyMachines.Logger.debug("----- " + String.valueOf(MarkerRegister));
        XyMachines.Logger.debug("-------- " + String.valueOf(MarkerRecipeManagerAccess));
        XyMachines.Logger.debug("-------- " + String.valueOf(MarkerAccessBlockStateMap));
        XyMachines.Logger.debug("-------- " + String.valueOf(MarkerSortingRecipes));
        XyMachines.Logger.debug("-------- " + String.valueOf(MarkerMapRules));
        XyMachines.Logger.debug("------------ " + String.valueOf(MarkerWaiting));
        XyMachines.Logger.debug("-------- " + String.valueOf(MarkerRegisterRecipes));
        XyMachines.Logger.debug("------------------------------------------------------------------------");
    }

    public static <T> Predicate<T> distinctPredicate(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static int compareItemResults(RecipeHolder<ExtractorRecipe> o1, RecipeHolder<ExtractorRecipe> o2) {
        ItemStack result1 = ((ExtractorRecipe)o1.value()).output().right().orElse(ItemStack.EMPTY);
        ItemStack result2 = ((ExtractorRecipe)o2.value()).output().right().orElse(ItemStack.EMPTY);
        if (result1.isEmpty() || result2.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)result1, (ItemStack)result2)) {
            return 0;
        }
        String path1 = result1.getHoverName().getString();
        String path2 = result2.getHoverName().getString();
        return path1.compareToIgnoreCase(path2);
    }

    private static int compareFluidResults(RecipeHolder<ExtractorRecipe> o1, RecipeHolder<ExtractorRecipe> o2) {
        FluidStack result1 = ((ExtractorRecipe)o1.value()).output().left().orElse(FluidStack.EMPTY);
        FluidStack result2 = ((ExtractorRecipe)o2.value()).output().left().orElse(FluidStack.EMPTY);
        if (result1.isEmpty() || result2.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)result1, (FluidStack)result2)) {
            return 0;
        }
        String path1 = result1.getHoverName().getString();
        String path2 = result2.getHoverName().getString();
        return path1.compareToIgnoreCase(path2);
    }
}

