/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import tv.soaryn.xycraft.api.content.pipes.EdgeData;

public class ClientPipeGraphCacheAttachment {
    public static final AttachmentType.Builder<ClientPipeGraphCacheAttachment> Builder = AttachmentType.builder(ClientPipeGraphCacheAttachment::new);
    public final Object2ObjectOpenHashMap<UUID, Graph<Long, EdgeData>> IdToGraph = new Object2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<UUID> PosToId = new Long2ObjectOpenHashMap();
    public final Object2ObjectOpenHashMap<UUID, ClientBuffer> IdToData = new Object2ObjectOpenHashMap();

    private ClientPipeGraphCacheAttachment() {
    }

    public void add(UUID id, LongArraySet nodes, Set<EdgeData> edges) {
        Graph graph = (Graph)this.IdToGraph.computeIfAbsent((Object)id, i -> new SimpleDirectedWeightedGraph(EdgeData.class));
        Graphs.addAllVertices((Graph)graph, (Collection)nodes);
        for (EdgeData edge : edges) {
            if (graph.containsEdge((Object)edge.src(), (Object)edge.dst())) continue;
            graph.addEdge((Object)edge.src(), (Object)edge.dst(), (Object)new EdgeData(edge.src(), edge.dst(), edge.weight()));
            graph.setEdgeWeight((Object)edge.src(), (Object)edge.dst(), (double)edge.weight());
        }
        for (Object node : (Object)nodes.toLongArray()) {
            this.PosToId.put((long)node, (Object)id);
        }
        this.IdToGraph.put((Object)id, (Object)graph);
    }

    public void update(UUID id, FluidStack stack, long amount) {
        ClientBuffer buffer = (ClientBuffer)this.IdToData.computeIfAbsent((Object)id, o -> new ClientBuffer());
        buffer.Fluid = stack;
        buffer.Amount = amount;
    }

    public void remove(UUID id) {
        Graph graph = (Graph)this.IdToGraph.remove((Object)id);
        if (graph == null) {
            return;
        }
        this.IdToData.remove((Object)id);
        Iterator iterator = graph.vertexSet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            if (!id.equals(this.PosToId.get(l))) continue;
            this.PosToId.remove(l);
        }
    }

    public void remove(long posId) {
        UUID id = (UUID)this.PosToId.remove(posId);
        if (id == null) {
            return;
        }
        Graph graph = (Graph)this.IdToGraph.get((Object)id);
        if (graph == null) {
            return;
        }
        graph.removeVertex((Object)posId);
        if (graph.vertexSet().isEmpty()) {
            this.IdToGraph.remove((Object)id);
            this.IdToData.remove((Object)id);
        }
    }

    public static class ClientBuffer {
        public static ClientBuffer Empty = new ClientBuffer();
        public FluidStack Fluid = FluidStack.EMPTY;
        public long Amount = 0L;
    }
}

