/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandPose;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandStyleOption;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.network.client.C2SStrawStatueModelPartMessage;
import fuzs.strawstatues.network.client.C2SStrawStatueScaleMessage;
import fuzs.strawstatues.network.client.C2SStrawStatueSetProfileMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrawStatues
implements ModConstructor {
    public static final String MOD_ID = "strawstatues";
    public static final String MOD_NAME = "Straw Statues";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Straw Statues");
    public static final NetworkHandler NETWORK = NetworkHandler.builder((String)"strawstatues").registerLegacyServerbound(C2SStrawStatueModelPartMessage.class, C2SStrawStatueModelPartMessage::new).registerLegacyServerbound(C2SStrawStatueSetProfileMessage.class, C2SStrawStatueSetProfileMessage::new).registerLegacyServerbound(C2SStrawStatueScaleMessage.class, C2SStrawStatueScaleMessage::new);

    public void onConstructMod() {
        ModRegistry.touch();
        StrawStatues.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        PlayerInteractEvents.USE_ENTITY_AT.register(EventPhase.BEFORE, StrawStatue::onUseEntityAt);
    }

    public void onCommonSetup() {
        ArmorStandStyleOption.register((ResourceLocation)StrawStatues.id("slimarms"), (ArmorStandStyleOption)ModRegistry.SLIM_ARMS_STYLE_OPTION);
        ArmorStandStyleOption.register((ResourceLocation)StrawStatues.id("crouching"), (ArmorStandStyleOption)ModRegistry.CROUCHING_STYLE_OPTION);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModRegistry.STRAW_STATUE_ITEM.value()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(this){

            public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                ServerLevel serverLevel = blockSource.level();
                Consumer consumer = EntityType.appendDefaultStackConfig(strawStatue -> {
                    strawStatue.setYRot(direction.toYRot());
                    ArmorStandPose.randomValue().applyToEntity((ArmorStand)strawStatue);
                }, (ServerLevel)serverLevel, (ItemStack)itemStack, null);
                StrawStatue strawStatue2 = (StrawStatue)((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()).spawn(serverLevel, consumer, blockPos, MobSpawnType.DISPENSER, false, false);
                if (strawStatue2 != null) {
                    itemStack.shrink(1);
                }
                return itemStack;
            }
        });
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value(), ArmorStand.createAttributes());
    }

    public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
        context.registerBuildListener(CreativeModeTabs.FUNCTIONAL_BLOCKS, (itemDisplayParameters, output) -> output.accept((ItemLike)ModRegistry.STRAW_STATUE_ITEM.value()));
        context.registerBuildListener(CreativeModeTabs.REDSTONE_BLOCKS, (itemDisplayParameters, output) -> output.accept((ItemLike)ModRegistry.STRAW_STATUE_ITEM.value()));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

