/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.shape.v1.ShapesHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFrameItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemFrameBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
TickingEntityBlock<ItemFrameBlockEntity> {
    public static final MapCodec<ItemFrameBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(itemFrame -> itemFrame.item), (App)ItemFrameBlock.propertiesCodec()).apply((Applicative)instance, ItemFrameBlock::new));
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");
    public static final BooleanProperty HAS_MAP = BooleanProperty.create((String)"has_map");
    public static final BooleanProperty DYED = BooleanProperty.create((String)"dyed");
    static final VoxelShape SHAPE = ItemFrameBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    static final VoxelShape MAP_SHAPE = ItemFrameBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    static final Map<Direction, VoxelShape> SHAPES = ShapesHelper.rotate((VoxelShape)SHAPE);
    static final Map<Direction, VoxelShape> MAP_SHAPES = ShapesHelper.rotate((VoxelShape)MAP_SHAPE);
    public static final Map<Item, Block> BY_ITEM = new HashMap<Item, Block>();
    private final Item item;

    public ItemFrameBlock(Item item, BlockBehaviour.Properties properties) {
        super(properties);
        this.item = item;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)INVISIBLE, (Comparable)Boolean.FALSE)).setValue((Property)HAS_MAP, (Comparable)Boolean.FALSE)).setValue((Property)DYED, (Comparable)Boolean.FALSE));
        Item.BY_BLOCK.put(this, item);
        BY_ITEM.put(item, (Block)this);
    }

    protected MapCodec<? extends ItemFrameBlock> codec() {
        return CODEC;
    }

    public Item asItem() {
        return this.item;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemFrameBlockEntity blockEntity;
        ItemFrame itemFrame;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
            InteractionResult result;
            if (player.isSecondaryUseActive() && !this.isFixed((LevelReader)level, pos) && !itemFrame.getItem().isEmpty()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)INVISIBLE) == false)), 2);
                itemFrame.playSound(itemFrame.getRotateItemSound(), 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (itemFrame.getItem().isEmpty()) {
                itemFrame.setRotation(0);
            }
            if ((result = itemFrame.interact(player, hand)).consumesAction()) {
                blockEntity.markUpdated();
            }
            return switch (result) {
                default -> throw new MatchException(null, null);
                case InteractionResult.PASS -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                case InteractionResult.SUCCESS, InteractionResult.SUCCESS_NO_ITEM_USED -> ItemInteractionResult.SUCCESS;
                case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
                case InteractionResult.CONSUME -> ItemInteractionResult.CONSUME;
                case InteractionResult.CONSUME_PARTIAL -> ItemInteractionResult.CONSUME_PARTIAL;
            };
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HAS_MAP) != false ? MAP_SHAPES.get(state.getValue((Property)FACING)) : SHAPES.get(state.getValue((Property)FACING));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)context).getEntity()) instanceof Projectile) {
            Level level;
            Projectile projectile = (Projectile)entity;
            if (blockGetter instanceof Level && projectile.mayInteract(level = (Level)blockGetter, pos) && projectile.mayBreak(level)) {
                return this.getShape(state, blockGetter, pos, context);
            }
        }
        return super.getCollisionShape(state, blockGetter, pos, context);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isFixed(level, pos)) {
            return true;
        }
        BlockState blockState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        return blockState.isSolid() || DiodeBlock.isDiode((BlockState)blockState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluidState.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockEntityType<? extends ItemFrameBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.ITEM_FRAME_BLOCK_ENTITY.value();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, INVISIBLE, HAS_MAP, WATERLOGGED, DYED});
    }

    public boolean isFixed(LevelReader level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ItemFrameBlockEntity) {
            ItemFrameBlockEntity blockEntity2 = (ItemFrameBlockEntity)blockEntity;
            ItemFrame itemFrame = blockEntity2.getEntityRepresentation();
            return itemFrame != null && itemFrame.fixed;
        }
        return false;
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.getBlockPos();
        if (!level.isClientSide && !this.isFixed((LevelReader)level, blockPos) && projectile.mayInteract(level, blockPos) && projectile.mayBreak(level)) {
            level.destroyBlock(blockPos, true, (Entity)projectile);
            level.updateNeighborsAt(blockPos, (Block)this);
            level.updateNeighborsAt(blockPos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            ItemFrameBlockEntity blockEntity;
            ItemFrame itemFrame;
            BlockEntity blockEntity2 = level.getBlockEntity(pos);
            if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
                itemFrame.dropItem(null, false);
                blockEntity.setChanged();
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        ItemFrameBlockEntity blockEntity;
        ItemFrame itemFrame;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
            return itemFrame.getAnalogOutput();
        }
        return 0;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemFrameBlockEntity) {
            OptionalInt color;
            ItemFrame itemFrame;
            ItemFrameBlockEntity blockEntity2 = (ItemFrameBlockEntity)blockEntity;
            ItemStack itemStack = null;
            if ((!Proxy.INSTANCE.hasControlDown() || ModLoaderEnvironment.INSTANCE.isClient() && !Proxy.INSTANCE.getClientPlayer().isCreative()) && (itemFrame = blockEntity2.getEntityRepresentation()) != null) {
                itemStack = itemFrame.getPickResult();
            }
            if (itemStack == null) {
                itemStack = super.getCloneItemStack(level, pos, state);
            }
            if (itemStack.getItem() instanceof ItemFrameItem && (color = blockEntity2.getColor()).isPresent()) {
                ItemFrameBlock.setItemFrameColor(itemStack, color.getAsInt());
            }
            return itemStack;
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    public static ItemStack setItemFrameColor(ItemStack itemStack, int color) {
        itemStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
        return itemStack;
    }
}

