/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.s2c;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.storage.ClientStorageRepository;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record StorageInfoResponsePacket(UUID storageId, long stored, long capacity) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StorageInfoResponsePacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("storage_info_response"));
    public static final StreamCodec<RegistryFriendlyByteBuf, StorageInfoResponsePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, StorageInfoResponsePacket::storageId, (StreamCodec)ByteBufCodecs.VAR_LONG, StorageInfoResponsePacket::stored, (StreamCodec)ByteBufCodecs.VAR_LONG, StorageInfoResponsePacket::capacity, StorageInfoResponsePacket::new);

    public static void handle(StorageInfoResponsePacket packet) {
        ClientStorageRepository storageRepository = (ClientStorageRepository)RefinedStorageApi.INSTANCE.getClientStorageRepository();
        storageRepository.updateInfo(packet.storageId, packet.stored, packet.capacity);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

