/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.support.amount.AbstractAmountScreen;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractSingleAmountContainerMenu;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Vector3f;

public abstract class AbstractSingleAmountScreen<T extends AbstractSingleAmountContainerMenu>
extends AbstractAmountScreen<T, Double> {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/amount_with_inventory.png");

    protected AbstractSingleAmountScreen(T containerMenu, Inventory playerInventory, Component title, Double initialAmount, Supplier<Double> minAmount) {
        super(containerMenu, null, playerInventory, title, AmountScreenConfiguration.AmountScreenConfigurationBuilder.create().withInitialAmount(initialAmount).withIncrementsTop(1, 10, 64).withIncrementsBottom(-1, -10, -64).withIncrementsTopStartPosition(new Vector3f(40.0f, 20.0f, 0.0f)).withIncrementsBottomStartPosition(new Vector3f(40.0f, 70.0f, 0.0f)).withAmountFieldWidth(59).withAmountFieldPosition(new Vector3f(45.0f, 51.0f, 0.0f)).withActionButtonsEnabled(false).withMinAmount(minAmount).withResetAmount(minAmount.get()).build(), DoubleAmountOperations.INSTANCE);
        this.inventoryLabelY = 94;
        this.imageWidth = 176;
        this.imageHeight = 188;
    }

    @Override
    protected boolean confirm(Double amount) {
        ((AbstractSingleAmountContainerMenu)this.getMenu()).changeAmountOnClient(amount);
        return true;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        this.renderPlayerInventoryTitle(graphics);
    }
}

