/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.Sounds;
import com.refinedmods.refinedstorage.common.networking.AbstractCableBlockEntity;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.PlayerAwareBlockEntity;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeMenuProvider;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractBaseBlock
extends Block {
    private static final TagKey<Item> WRENCH_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/wrench"));

    protected AbstractBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState(this.getDefaultState());
    }

    protected BlockState getDefaultState() {
        return (BlockState)this.getStateDefinition().any();
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.tryOpenScreen(state, level, pos, player, hitResult.getLocation()).orElseGet(() -> super.useWithoutItem(state, level, pos, player, hitResult));
    }

    @Nullable
    protected VoxelShape getScreenOpenableShape(BlockState state) {
        return null;
    }

    private Optional<InteractionResult> tryOpenScreen(BlockState state, Level level, BlockPos pos, Player player, Vec3 hit) {
        BlockEntity blockEntity;
        VoxelShape screenOpenableShape = this.getScreenOpenableShape(state);
        if (screenOpenableShape != null) {
            boolean inBounds;
            AABB aabb = screenOpenableShape.bounds().move(pos);
            boolean inBoundsX = hit.x >= aabb.minX && hit.x <= aabb.maxX;
            boolean inBoundsY = hit.y >= aabb.minY && hit.y <= aabb.maxY;
            boolean inBoundsZ = hit.z >= aabb.minZ && hit.z <= aabb.maxZ;
            boolean bl = inBounds = inBoundsX && inBoundsY && inBoundsZ;
            if (!inBounds) {
                return Optional.empty();
            }
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.tryOpenScreen(serverPlayer, provider);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    private void tryOpenScreen(ServerPlayer player, MenuProvider menuProvider) {
        NetworkNodeMenuProvider networkNodeMenuProvider;
        if (menuProvider instanceof NetworkNodeMenuProvider && !(networkNodeMenuProvider = (NetworkNodeMenuProvider)menuProvider).canOpen(player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionToOpenMessage(player, (Component)this.getName());
            return;
        }
        Platform.INSTANCE.getMenuOpener().openMenu(player, menuProvider);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock() && !state.getBlock().getClass().equals(newState.getBlock().getClass())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BlockEntityWithDrops) {
                BlockEntityWithDrops blockEntityDrops = (BlockEntityWithDrops)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, blockEntityDrops.getDrops());
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof PlayerAwareBlockEntity) {
                PlayerAwareBlockEntity playerAware = (PlayerAwareBlockEntity)blockEntity;
                playerAware.setPlacedBy(player.getGameProfile().getId());
            }
        }
    }

    public final Optional<InteractionResult> tryUseWrench(BlockState state, Level level, BlockHitResult hitResult, Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        boolean success;
        if (player.isSpectator() || !level.mayInteract(player, hitResult.getBlockPos())) {
            return Optional.empty();
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        boolean holdingWrench = this.isWrench(itemInHand);
        if (!holdingWrench) {
            return Optional.empty();
        }
        boolean isWrenchingOwnBlock = state.getBlock() instanceof AbstractBaseBlock;
        if (!isWrenchingOwnBlock) {
            return Optional.empty();
        }
        if (player instanceof ServerPlayer && (success = this.dismantleOrRotate(state, level, hitResult, serverPlayer = (ServerPlayer)player))) {
            level.playSound(null, hitResult.getBlockPos(), Sounds.INSTANCE.getWrench(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return Optional.of(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
    }

    private boolean dismantleOrRotate(BlockState state, Level level, BlockHitResult hitResult, ServerPlayer player) {
        if (player.isCrouching()) {
            return this.dismantle(state, level, hitResult, player);
        }
        return this.rotate(state, level, hitResult.getBlockPos(), hitResult.getDirection(), player);
    }

    private boolean rotate(BlockState state, Level level, BlockPos pos, Direction direction, ServerPlayer player) {
        NetworkNodeContainerProvider provider = Platform.INSTANCE.getContainerProvider(level, pos, direction);
        if (provider != null && !provider.canBuild(player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(player, (Component)IdentifierUtil.createTranslation("misc", "no_permission.build.rotate", this.getName()));
            return false;
        }
        BlockState rotated = this.getRotatedBlockState(state, level, pos);
        level.setBlockAndUpdate(pos, rotated);
        return !state.equals(rotated);
    }

    protected BlockState getRotatedBlockState(BlockState state, Level level, BlockPos pos) {
        return state.rotate(Rotation.CLOCKWISE_90);
    }

    private boolean isWrench(ItemStack item) {
        return item.is(WRENCH_TAG);
    }

    private boolean dismantle(BlockState state, Level level, BlockHitResult hitResult, ServerPlayer player) {
        NetworkNodeContainerProvider provider = Platform.INSTANCE.getContainerProvider(level, hitResult.getBlockPos(), hitResult.getDirection());
        if (provider != null && !provider.canBuild(player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(player, (Component)IdentifierUtil.createTranslation("misc", "no_permission.build.dismantle", this.getName()));
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(hitResult.getBlockPos());
        ItemStack stack = Platform.INSTANCE.getCloneItemStack(state, level, hitResult, (Player)player);
        if (blockEntity != null) {
            if (!(blockEntity instanceof AbstractCableBlockEntity)) {
                blockEntity.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
                CustomData.update((DataComponentType)DataComponents.BLOCK_ENTITY_DATA, (ItemStack)stack, CableConnections::stripTag);
            }
            level.removeBlockEntity(hitResult.getBlockPos());
        }
        level.setBlockAndUpdate(hitResult.getBlockPos(), Blocks.AIR.defaultBlockState());
        level.addFreshEntity((Entity)new ItemEntity(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z, stack));
        return true;
    }

    public final Optional<InteractionResult> tryUpdateColor(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        AbstractBaseBlock abstractBaseBlock = this;
        if (abstractBaseBlock instanceof ColorableBlock) {
            ColorableBlock colorableBlock = (ColorableBlock)((Object)abstractBaseBlock);
            return this.tryUpdateColor(colorableBlock.getBlockColorMap(), state, level, pos, player, hand);
        }
        return Optional.empty();
    }

    private Optional<InteractionResult> tryUpdateColor(BlockColorMap<?, ?> blockColorMap, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (!player.isCrouching()) {
            return Optional.empty();
        }
        return blockColorMap.updateColor(state, player.getItemInHand(hand), level, pos, player);
    }
}

