/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

class CompositePatternProviderExternalPatternSink
implements PlatformPatternProviderExternalPatternSink {
    private final Set<PlatformPatternProviderExternalPatternSink> sinks;

    CompositePatternProviderExternalPatternSink(Set<PlatformPatternProviderExternalPatternSink> sinks) {
        this.sinks = sinks;
    }

    @Override
    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        Set<PatternProviderExternalPatternSink> sortedSinks = this.getSortedSinks(resources);
        ExternalPatternSink.Result result = ExternalPatternSink.Result.SKIPPED;
        for (PatternProviderExternalPatternSink sink : sortedSinks) {
            ExternalPatternSink.Result sinkResult = sink.accept(resources, action);
            if (sinkResult == ExternalPatternSink.Result.REJECTED) {
                return sinkResult;
            }
            result = this.and(result, sinkResult);
        }
        return result;
    }

    private Set<PatternProviderExternalPatternSink> getSortedSinks(Collection<ResourceAmount> resources) {
        Set order = resources.stream().map(ResourceAmount::resource).collect(Collectors.toCollection(LinkedHashSet::new));
        return order.stream().flatMap(resource -> this.sinks.stream().filter(sink -> sink.applies((ResourceKey)resource))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private ExternalPatternSink.Result and(ExternalPatternSink.Result a, ExternalPatternSink.Result b) {
        if (a == ExternalPatternSink.Result.SKIPPED) {
            return b;
        }
        if (a == ExternalPatternSink.Result.REJECTED || b == ExternalPatternSink.Result.REJECTED) {
            return ExternalPatternSink.Result.REJECTED;
        }
        return ExternalPatternSink.Result.ACCEPTED;
    }

    @Override
    public boolean isEmpty() {
        for (PlatformPatternProviderExternalPatternSink sink : this.sinks) {
            if (sink.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

