/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.simplifiers;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.simmetrics.simplifiers.Simplifier;

public final class Simplifiers {
    public static Simplifier chain(List<Simplifier> simplifiers) {
        if (simplifiers.size() == 1) {
            return simplifiers.get(0);
        }
        return new ChainSimplifier(Simplifiers.flatten(simplifiers));
    }

    public static Simplifier chain(Simplifier simplifier, Simplifier ... simplifiers) {
        Preconditions.checkArgument((simplifier != null ? 1 : 0) != 0);
        if (simplifiers.length == 0) {
            return simplifier;
        }
        return Simplifiers.chain(Lists.asList((Object)simplifier, (Object[])simplifiers));
    }

    private static List<Simplifier> flatten(List<Simplifier> simplifiers) {
        ArrayList<Simplifier> flattend = new ArrayList<Simplifier>(simplifiers.size());
        for (Simplifier s : simplifiers) {
            if (s instanceof ChainSimplifier) {
                ChainSimplifier c = (ChainSimplifier)s;
                flattend.addAll(c.getSimplifiers());
                continue;
            }
            flattend.add(s);
        }
        return flattend;
    }

    public static Simplifier normalize(Normalizer.Form form) {
        return new Normalize(form);
    }

    public static Simplifier removeAll(String regex) {
        return Simplifiers.removeAll(Pattern.compile(regex));
    }

    public static Simplifier removeAll(Pattern pattern) {
        return new ReplaceAll(pattern, "");
    }

    public static Simplifier removeDiacritics() {
        return new RemoveDiacritics();
    }

    public static Simplifier removeNonWord() {
        return Simplifiers.removeNonWord("");
    }

    public static Simplifier removeNonWord(String replacement) {
        return Simplifiers.removeAll("\\W+");
    }

    public static Simplifier replaceAll(String regex, String replacement) {
        return Simplifiers.replaceAll(Pattern.compile(regex), replacement);
    }

    public static Simplifier replaceAll(Pattern pattern, String replacement) {
        return new ReplaceAll(pattern, replacement);
    }

    public static Simplifier replaceNonWord() {
        return Simplifiers.replaceNonWord(" ");
    }

    public static Simplifier replaceNonWord(String replacement) {
        return Simplifiers.replaceAll("\\W", replacement);
    }

    public static Simplifier toLowerCase() {
        return Simplifiers.toLowerCase(Locale.getDefault());
    }

    public static Simplifier toLowerCase(Locale l) {
        return new ToLowerCase(l);
    }

    public static Simplifier toUpperCase() {
        return Simplifiers.toUpperCase(Locale.getDefault());
    }

    public static Simplifier toUpperCase(Locale l) {
        return new ToUpperCase(l);
    }

    private Simplifiers() {
    }

    static final class ChainSimplifier
    implements Simplifier {
        private final List<Simplifier> simplifiers;

        ChainSimplifier(List<Simplifier> simplifiers) {
            Preconditions.checkArgument((!simplifiers.contains(null) ? 1 : 0) != 0);
            this.simplifiers = ImmutableList.copyOf(simplifiers);
        }

        List<Simplifier> getSimplifiers() {
            return this.simplifiers;
        }

        @Override
        public String simplify(String input) {
            Preconditions.checkNotNull((Object)input);
            String output = input;
            for (Simplifier s : this.simplifiers) {
                output = s.simplify(output);
            }
            return output;
        }

        public String toString() {
            return Joiner.on((String)" -> ").join(this.simplifiers);
        }
    }

    static final class Normalize
    implements Simplifier {
        private final Normalizer.Form form;

        public Normalize(Normalizer.Form form) {
            this.form = form;
        }

        @Override
        public String simplify(String input) {
            return Normalizer.normalize(input, this.form);
        }

        public String toString() {
            return "Normalize[" + String.valueOf((Object)this.form) + "]";
        }

        Normalizer.Form getForm() {
            return this.form;
        }
    }

    static final class ReplaceAll
    implements Simplifier {
        private final Pattern pattern;
        private final String repplacement;

        public ReplaceAll(Pattern pattern, String replacement) {
            Preconditions.checkNotNull((Object)replacement);
            Preconditions.checkNotNull((Object)pattern);
            this.pattern = pattern;
            this.repplacement = replacement;
        }

        @Override
        public String simplify(String input) {
            return this.pattern.matcher(input).replaceAll(this.repplacement);
        }

        public String toString() {
            return "Replace [" + String.valueOf(this.pattern) + " -> '" + this.repplacement + "' ]";
        }
    }

    static final class RemoveDiacritics
    implements Simplifier {
        private static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

        RemoveDiacritics() {
        }

        @Override
        public String simplify(String input) {
            return DIACRITICS_AND_FRIENDS.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
        }

        public String toString() {
            return "RemoveDiacritics";
        }
    }

    static final class ToLowerCase
    implements Simplifier {
        private final Locale locale;

        ToLowerCase(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String simplify(String s) {
            return s.toLowerCase(this.locale);
        }

        public String toString() {
            return "ToLowerCase [locale=" + String.valueOf(this.locale) + "]";
        }
    }

    static final class ToUpperCase
    implements Simplifier {
        private final Locale locale;

        ToUpperCase(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String simplify(String s) {
            return s.toUpperCase(this.locale);
        }

        public String toString() {
            return "ToUpperCase [locale=" + String.valueOf(this.locale) + "]";
        }
    }
}

