/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import org.simmetrics.StringDistance;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.Math;

public final class DamerauLevenshtein
implements StringMetric,
StringDistance {
    private final float maxCost;
    private final float insertDelete;
    private final float substitute;
    private final float transpose;

    public DamerauLevenshtein() {
        this(1.0f, 1.0f, 1.0f);
    }

    public DamerauLevenshtein(float insertDelete, float substitute, float transpose) {
        Preconditions.checkArgument((insertDelete > 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((substitute >= 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((transpose >= 0.0f ? 1 : 0) != 0);
        this.maxCost = Math.max(insertDelete, substitute, transpose);
        this.insertDelete = insertDelete;
        this.substitute = substitute;
        this.transpose = transpose;
    }

    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        return 1.0f - this.distance(a, b) / (this.maxCost * (float)java.lang.Math.max(a.length(), b.length()));
    }

    @Override
    public float distance(String s, String t) {
        int i;
        if (s.isEmpty()) {
            return (float)t.length() * this.insertDelete;
        }
        if (t.isEmpty()) {
            return (float)s.length() * this.insertDelete;
        }
        if (s.equals(t)) {
            return 0.0f;
        }
        int tLength = t.length();
        int sLength = s.length();
        float[] v0 = new float[tLength + 1];
        float[] v1 = new float[tLength + 1];
        float[] v2 = new float[tLength + 1];
        for (i = 0; i < v1.length; ++i) {
            v1[i] = (float)i * this.insertDelete;
        }
        for (i = 0; i < sLength; ++i) {
            v2[0] = (float)(i + 1) * this.insertDelete;
            for (int j = 0; j < tLength; ++j) {
                v2[j + 1] = j > 0 && i > 0 && s.charAt(i - 1) == t.charAt(j) && s.charAt(i) == t.charAt(j - 1) ? Math.min(v2[j] + this.insertDelete, v1[j + 1] + this.insertDelete, v1[j] + (s.charAt(i) == t.charAt(j) ? 0.0f : this.substitute), v0[j - 1] + this.transpose) : Math.min(v2[j] + this.insertDelete, v1[j + 1] + this.insertDelete, v1[j] + (s.charAt(i) == t.charAt(j) ? 0.0f : this.substitute));
            }
            float[] swap = v0;
            v0 = v1;
            v1 = v2;
            v2 = swap;
        }
        return v1[tLength];
    }

    public String toString() {
        return "DamerauLevenshtein [insertDelete=" + this.insertDelete + ", substitute=" + this.substitute + ", transpose=" + this.transpose + "]";
    }
}

