/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfm.common.program.linting.ProblemTracker;
import ca.teamdman.sfml.ast.Program;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LabelPresentButNotUsedProgramLinter
implements IProgramLinter {
    @Override
    public void gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity managerBlockEntity, ProblemTracker tracker) {
        int before = tracker.size();
        for (String x : labelPositionHolder.labels().keySet()) {
            if (program.referencedLabels().contains(x) || !tracker.add(LocalizationKeys.PROGRAM_WARNING_UNDEFINED_LABEL.get(x)).isSaturated()) continue;
            break;
        }
        if (tracker.size() > before) {
            tracker.add(LocalizationKeys.PROGRAM_REMINDER_PUSH_LABELS.get());
        }
    }

    @Override
    public void fixWarnings(Program program, LabelPositionHolder labels, ManagerBlockEntity manager, Level level, ItemStack disk) {
        labels.removeIf(label -> !program.referencedLabels().contains(label));
    }
}

