/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ClientboundManagerLogsPacket(int windowId, FriendlyByteBuf logsBuf) implements SFMPacket
{
    public static ClientboundManagerLogsPacket drainToCreate(int windowId, Collection<TranslatableLogEvent> logs) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        TranslatableLogger.encodeAndDrain(logs, buf);
        return new ClientboundManagerLogsPacket(windowId, buf);
    }

    public static class Daddy
    implements SFMPacketDaddy<ClientboundManagerLogsPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.CLIENTBOUND;
        }

        @Override
        public void encode(ClientboundManagerLogsPacket msg, RegistryFriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeVarInt(msg.windowId());
            friendlyByteBuf.writeVarInt(msg.logsBuf.readableBytes());
            friendlyByteBuf.writeBytes((ByteBuf)msg.logsBuf, 0, msg.logsBuf.readableBytes());
        }

        @Override
        public ClientboundManagerLogsPacket decode(RegistryFriendlyByteBuf friendlyByteBuf) {
            int windowId = friendlyByteBuf.readVarInt();
            int size = friendlyByteBuf.readVarInt();
            FriendlyByteBuf logsBuf = new FriendlyByteBuf(Unpooled.buffer((int)size));
            friendlyByteBuf.readBytes((ByteBuf)logsBuf, size);
            return new ClientboundManagerLogsPacket(windowId, logsBuf);
        }

        @Override
        public void handle(ClientboundManagerLogsPacket msg, SFMPacketHandlingContext context) {
            ManagerContainerMenu menu;
            block3: {
                block2: {
                    AbstractContainerMenu abstractContainerMenu;
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (player == null || !((abstractContainerMenu = player.containerMenu) instanceof ManagerContainerMenu)) break block2;
                    menu = (ManagerContainerMenu)abstractContainerMenu;
                    if (menu.containerId == msg.windowId()) break block3;
                }
                return;
            }
            ArrayDeque<TranslatableLogEvent> logs = TranslatableLogger.decode(msg.logsBuf);
            menu.logs.addAll(logs);
        }

        @Override
        public Class<ClientboundManagerLogsPacket> getPacketClass() {
            return ClientboundManagerLogsPacket.class;
        }
    }
}

