/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.text_editor;

import ca.teamdman.sfm.client.examples.SFMExampleProgram;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditScreenOpenContext;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public record SFMTextEditScreenExampleProgramOpenContext(String initialExampleContent, String initialDiskContent, List<SFMExampleProgram> examples, LabelPositionHolder labelPositionHolder, Consumer<String> saveWriter) implements ISFMTextEditScreenOpenContext
{
    @Override
    public void onSaveAndClose(String latestContent) {
        if (this.isSafeToOverwriteDisk()) {
            ISFMTextEditScreenOpenContext.super.onSaveAndClose(latestContent);
        } else {
            ConfirmScreen saveConfirmScreen = new ConfirmScreen(saidYes -> {
                SFMScreenChangeHelpers.popScreen();
                if (saidYes) {
                    ISFMTextEditScreenOpenContext.super.onSaveAndClose(latestContent);
                }
            }, (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_NO_BUTTON.getComponent());
            SFMScreenChangeHelpers.setOrPushScreen((Screen)saveConfirmScreen);
            saveConfirmScreen.setDelay(20);
        }
    }

    @Override
    public String initialValue() {
        return this.initialExampleContent();
    }

    public boolean equalsAnyTemplate(String content) {
        return this.examples().stream().map(SFMExampleProgram::programString).map(String::trim).anyMatch(content.trim()::equals);
    }

    public boolean isSafeToOverwriteDisk() {
        if (this.initialDiskContent().isBlank()) {
            return true;
        }
        return this.equalsAnyTemplate(this.initialDiskContent());
    }
}

