/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.item;

import com.benbenlaw.routers.item.RoutersDataComponents;
import com.benbenlaw.routers.item.RoutersItems;
import com.benbenlaw.routers.networking.packets.FilterItemUpdate;
import com.benbenlaw.routers.screen.ConfigMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterItem
extends Item {
    public FilterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            BlockPos pos = player.blockPosition();
            SimpleContainerData data = new SimpleContainerData(2);
            player.openMenu((MenuProvider)new SimpleMenuProvider((arg_0, arg_1, arg_2) -> FilterItem.lambda$use$0(pos, (ContainerData)data, arg_0, arg_1, arg_2), (Component)Component.translatable((String)"screen.routers.config_screen")), buf -> buf.writeBlockPos(pos));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (stack.is(RoutersItems.TAG_FILTER)) {
                if (stack.has((DataComponentType)RoutersDataComponents.TAG_FILTER.get())) {
                    ResourceLocation tag = (ResourceLocation)stack.get((DataComponentType)RoutersDataComponents.TAG_FILTER.get());
                    assert (tag != null);
                    components.add((Component)Component.translatable((String)"tooltip.routers.tag_filter", (Object[])new Object[]{tag.toString()}).withStyle(ChatFormatting.YELLOW));
                } else {
                    components.add((Component)Component.translatable((String)"tooltip.routers.tag_filter_empty").withStyle(ChatFormatting.YELLOW));
                }
            }
            if (stack.is(RoutersItems.MOD_FILTER)) {
                if (stack.has((DataComponentType)RoutersDataComponents.MOD_FILTER.get())) {
                    String mod = (String)stack.get((DataComponentType)RoutersDataComponents.MOD_FILTER.get());
                    components.add((Component)Component.translatable((String)"tooltip.routers.mod_filter", (Object[])new Object[]{mod}).withStyle(ChatFormatting.YELLOW));
                } else {
                    components.add((Component)Component.translatable((String)"tooltip.routers.mod_filter_empty").withStyle(ChatFormatting.YELLOW));
                }
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltip.routers.hold_shift").withStyle(ChatFormatting.YELLOW));
        }
    }

    public void setTag(ItemStack stack, ResourceLocation tag) {
        stack.set((DataComponentType)RoutersDataComponents.TAG_FILTER.get(), (Object)tag);
        PacketDistributor.sendToServer((CustomPacketPayload)new FilterItemUpdate(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setMod(ItemStack stack, String mod) {
        stack.set((DataComponentType)RoutersDataComponents.MOD_FILTER.get(), (Object)mod);
        PacketDistributor.sendToServer((CustomPacketPayload)new FilterItemUpdate(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public TagKey<Item> getTag(ItemStack stack) {
        ResourceLocation tagLocation;
        if (stack.is(RoutersItems.TAG_FILTER) && stack.has((DataComponentType)RoutersDataComponents.TAG_FILTER.get()) && (tagLocation = (ResourceLocation)stack.get((DataComponentType)RoutersDataComponents.TAG_FILTER.get())) != null) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLocation);
        }
        return null;
    }

    private static /* synthetic */ AbstractContainerMenu lambda$use$0(BlockPos pos, ContainerData data, int windowId, Inventory playerInventory, Player playerEntity) {
        return new ConfigMenu(windowId, playerInventory, pos, data);
    }
}

