/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.api.registry.Talent;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogNodeEvaluator;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.dogpromise.DogPromiseManager;
import doggytalents.common.util.dogpromise.promise.DogDistantTeleportToBedPromise;
import doggytalents.common.util.dogpromise.promise.DogDistantTeleportToOwnerCrossDimensionPromise;
import doggytalents.common.util.dogpromise.promise.DogDistantTeleportToOwnerPromise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DogUtil {
    private static List<Character> INVALID_NAME_CHARS = List.of(Character.valueOf('\"'));

    public static boolean dynamicSearchAndTeleportToOwnwer(Dog dog, LivingEntity owner, int radius) {
        BlockPos target = owner.isSprinting() || dog.avoidGoInFrontOfOwnerManager.isActive() ? CachedSearchUtil.getRandomSafePosUsingPoolExcludeInfrontOfOwner(dog, owner, owner.blockPosition(), radius, 1) : CachedSearchUtil.getRandomSafePosUsingPool(dog, owner.blockPosition(), radius, 1);
        if (target == null) {
            return false;
        }
        DogUtil.teleportDogAbs(dog, target);
        return true;
    }

    public static boolean dynamicSearchAndTeleportToOwnwerInBatch(Level level, List<Dog> dogs, LivingEntity owner, int radius) {
        if (dogs.isEmpty()) {
            return false;
        }
        List<BlockPos> safePosList = owner.isSprinting() ? CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(level, dogs, owner, owner.blockPosition(), radius, 1) : CachedSearchUtil.getAllSafePosUsingPool(level, dogs, owner.blockPosition(), radius, 1);
        if (safePosList.isEmpty()) {
            return false;
        }
        for (Dog dog : dogs) {
            int r_indx = dog.getRandom().nextInt(safePosList.size());
            DogUtil.teleportDogAbs(dog, safePosList.get(r_indx));
        }
        return true;
    }

    public static boolean dynamicSearchAndTeleportToOwnwerInBatchMaxDensity(Level level, List<Dog> dogs, LivingEntity owner, int radius, int max_density) {
        if (dogs.isEmpty()) {
            return false;
        }
        List<BlockPos> safePosList = owner.isSprinting() ? CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(level, dogs, owner, owner.blockPosition(), radius, 1) : CachedSearchUtil.getAllSafePosUsingPool(level, dogs, owner.blockPosition(), radius, 1);
        if (safePosList.isEmpty()) {
            return false;
        }
        ArrayList<Integer> densityMap = new ArrayList<Integer>(safePosList.size());
        for (int i = 0; i < safePosList.size(); ++i) {
            densityMap.add(0);
        }
        ArrayList<Dog> sorted_dogs = new ArrayList<Dog>(dogs);
        Collections.sort(sorted_dogs, new EntityUtil.Sorter((Entity)owner));
        for (Dog dog : sorted_dogs) {
            if (safePosList.isEmpty()) break;
            int r_indx = dog.getRandom().nextInt(safePosList.size());
            DogUtil.teleportDogAbs(dog, safePosList.get(r_indx));
            int density_count = (Integer)densityMap.get(r_indx) + 1;
            if (density_count >= max_density) {
                densityMap.remove(r_indx);
                safePosList.remove(r_indx);
                continue;
            }
            densityMap.set(r_indx, density_count);
        }
        return true;
    }

    public static boolean dynamicSearchAndTeleportToBlockPos(Dog dog, BlockPos pos, int radius) {
        BlockPos target = CachedSearchUtil.getRandomSafePosUsingPool(dog, pos, radius, 1);
        if (target == null) {
            return false;
        }
        DogUtil.teleportDogAbs(dog, target);
        return true;
    }

    public static boolean guessAndTryToTeleportToOwner(Dog dog, LivingEntity owner, int radius) {
        BlockPos owner_b0 = owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int randZ;
            int randY;
            int randX = owner_b0.getX() + EntityUtil.getRandomNumber((LivingEntity)dog, -radius, radius);
            BlockPos b0 = new BlockPos(randX, randY = owner_b0.getY() + EntityUtil.getRandomNumber((LivingEntity)dog, -1, 1), randZ = owner_b0.getZ() + EntityUtil.getRandomNumber((LivingEntity)dog, -radius, radius));
            if (!DogUtil.wantToTeleportToThePosition(dog, owner, b0)) continue;
            DogUtil.teleportDogAbs(dog, b0);
            return true;
        }
        return false;
    }

    public static boolean guessAndTryToTeleportToBlockPos(Dog dog, BlockPos pos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int randZ;
            int randY;
            int randX = pos.getX() + EntityUtil.getRandomNumber((LivingEntity)dog, -radius, radius);
            BlockPos b0 = new BlockPos(randX, randY = pos.getY() + EntityUtil.getRandomNumber((LivingEntity)dog, -1, 1), randZ = pos.getZ() + EntityUtil.getRandomNumber((LivingEntity)dog, -radius, radius));
            if (!DogUtil.isTeleportSafeBlock(dog, b0, null)) continue;
            DogUtil.teleportDogAbs(dog, b0);
            return true;
        }
        return false;
    }

    public static boolean wantToTeleportToThePosition(Dog dog, LivingEntity owner, BlockPos pos) {
        BlockPos owner_b0 = owner.blockPosition();
        boolean flag = (Mth.abs((int)(owner_b0.getX() - pos.getX())) >= 2 || Mth.abs((int)(owner_b0.getZ() - pos.getZ())) >= 2) && DogUtil.isTeleportSafeBlock(dog, pos, owner) && (!owner.isSprinting() && !dog.avoidGoInFrontOfOwnerManager.isActive() || !DogUtil.posWillCollideWithOwnerMovingForward(dog, owner, pos));
        return flag;
    }

    public static boolean posWillCollideWithOwnerMovingForward(Dog dog, LivingEntity owner, BlockPos pos) {
        float dz1;
        float a1;
        float dx1;
        Vec3 ownerLookUnitVector;
        double DISTANCE_AWAY = 1.5;
        Vec3 ownerPos = owner.position();
        Vec3 ownerPos2d = new Vec3(ownerPos.x(), 0.0, ownerPos.z());
        Vec3 targetPos2d = new Vec3((double)pos.getX() + 0.5, 0.0, (double)pos.getZ() + 0.5);
        double x = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(targetPos2d, ownerPos2d, ownerLookUnitVector = new Vec3((double)(dx1 = -Mth.sin((float)((a1 = owner.getYHeadRot()) * ((float)Math.PI / 180)))), 0.0, (double)(dz1 = Mth.cos((float)(a1 * ((float)Math.PI / 180))))));
        return !(x < 0.0) && !(x > 1.5);
    }

    public static boolean hasLineOfSightToOwnerAtPos(Dog dog, LivingEntity owner, BlockPos pos) {
        Vec3 pos2;
        Vec3 pos1 = new Vec3((double)pos.getX() + 0.5, (double)((float)pos.getY() + owner.getEyeHeight()), (double)pos.getZ() + 0.5);
        if (pos1.distanceTo(pos2 = new Vec3(owner.getX(), owner.getY() + (double)owner.getEyeHeight(), owner.getZ())) > 128.0) {
            return false;
        }
        return dog.level().clip(new ClipContext(pos1, pos2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dog)).getType() == HitResult.Type.MISS;
    }

    public static boolean isTeleportSafeBlock(Dog dog, BlockPos pos, @Nullable LivingEntity owner) {
        PathType pathnodetype = WalkNodeEvaluator.getPathTypeStatic((Mob)dog, (BlockPos)pos.mutable());
        boolean alterationWalkable = false;
        PathType infer_type = dog.inferType(pathnodetype, InferTypeContext.forTeleport(owner));
        if (infer_type == PathType.WALKABLE) {
            alterationWalkable = true;
        }
        if (dog.canDogFly() && pathnodetype == PathType.OPEN) {
            alterationWalkable = true;
        }
        if (dog.fireImmune() && pathnodetype == PathType.OPEN && dog.level().getFluidState(pos.below()).is(FluidTags.LAVA)) {
            alterationWalkable = true;
        }
        if (pathnodetype != PathType.WALKABLE && !alterationWalkable) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)dog.blockPosition());
        return dog.level().noCollision((Entity)dog, dog.getBoundingBox().move(blockpos));
    }

    public static boolean isTeleportSafeBlockMidAir(Dog dog, BlockPos pos) {
        PathType pathnodetype = WalkNodeEvaluator.getPathTypeStatic((Mob)dog, (BlockPos)pos.mutable());
        if (pathnodetype != PathType.OPEN) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)dog.blockPosition());
        return dog.level().noCollision((Entity)dog, dog.getBoundingBox().move(blockpos));
    }

    public static double distanceFromPointToLineOfUnitVector2DSqr(Vec3 A, Vec3 B, Vec3 v) {
        Vec3 u = A.add(B.scale(-1.0));
        double dot_u_v = u.dot(v);
        if (dot_u_v < 0.0) {
            return -1.0;
        }
        double dis_sqr = u.lengthSqr() - dot_u_v * dot_u_v;
        return dis_sqr;
    }

    public static boolean canPathReachTargetBlock(Dog dog, @Nonnull Path path, BlockPos pos, int maxDY_up, int maxDY_down) {
        Node endNode = path.getEndNode();
        if (endNode == null) {
            return false;
        }
        int dx = endNode.x - pos.getX();
        int dz = endNode.z - pos.getZ();
        int d_sqr = dx * dx + dz * dz;
        int dy = pos.getY() - endNode.y;
        return d_sqr <= 1 && -maxDY_down <= dy && dy <= maxDY_up;
    }

    public static boolean pathGoingInFrontOfOwner(Dog dog) {
        PathNavigation n = dog.getNavigation();
        Path p = n.getPath();
        if (p == null || p.getNodeCount() <= 0) {
            return false;
        }
        LivingEntity owner = dog.getOwner();
        if (owner == null) {
            return false;
        }
        int i0 = p.getNextNodeIndex();
        int i_end = Mth.clamp((int)(i0 + 5), (int)0, (int)p.getNodeCount());
        for (int i = i0; i < i_end; ++i) {
            boolean flag = DogUtil.posWillCollideWithOwnerMovingForward(dog, owner, p.getNodePos(i));
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean moveToIfReachOrElse(Dog dog, BlockPos pos, double speedModifier, int maxDY_up, int maxDY_down, Consumer<Dog> orElse) {
        Path p = dog.getNavigation().createPath(pos, 1);
        if (p == null) {
            orElse.accept(dog);
            return false;
        }
        if (DogUtil.canPathReachTargetBlock(dog, p, pos, maxDY_up, maxDY_down)) {
            dog.getNavigation().moveTo(p, speedModifier);
            return true;
        }
        orElse.accept(dog);
        return false;
    }

    public static void moveToOwnerOrTeleportIfFarAway(Dog dog, LivingEntity owner, double speedModifier, double distanceToTeleportSqr, boolean continueToMoveWhenTryTp, boolean forceTeleport, double distanceToForceTeleportSqr, int dY) {
        if (owner == null) {
            return;
        }
        double distance = dog.distanceToSqr((Entity)owner);
        if (!dog.isLeashed() && !dog.isPassenger()) {
            if (distance >= distanceToForceTeleportSqr) {
                if (forceTeleport) {
                    DogUtil.dynamicSearchAndTeleportToOwnwer(dog, owner, 4);
                } else {
                    DogUtil.guessAndTryToTeleportToOwner(dog, owner, 4);
                }
            } else if (distance >= distanceToTeleportSqr) {
                DogUtil.guessAndTryToTeleportToOwner(dog, owner, 4);
                if (continueToMoveWhenTryTp) {
                    dog.getNavigation().moveTo((Entity)owner, speedModifier);
                }
            } else {
                dog.getNavigation().moveTo((Entity)owner, speedModifier);
            }
        }
    }

    public static List<Dog> getOtherIncapacitatedDogNearby(Dog dog) {
        int SEARCH_RADIUS = 12;
        List l = dog.level().getEntitiesOfClass(Dog.class, dog.getBoundingBox().inflate((double)SEARCH_RADIUS, 2.0, (double)SEARCH_RADIUS), d -> d.isDefeated());
        return l;
    }

    public static void attemptToTeleportDogNearbyOrSendPromise(@Nonnull UUID dogUUID, @Nonnull ServerPlayer owner) {
        Level level = owner.level();
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            Entity e = sLevel.getEntity(dogUUID);
            if (e != null && e instanceof Dog) {
                Dog d = (Dog)e;
                DogUtil.dynamicSearchAndTeleportToOwnwer(d, (LivingEntity)owner, 4);
            } else {
                MinecraftServer server;
                DogLocationStorage storage = DogLocationStorage.get((Level)sLevel);
                DogLocationData data = storage.getData(dogUUID);
                if (data == null) {
                    return;
                }
                Vec3 dataPos = data.getPos();
                if (dataPos == null) {
                    return;
                }
                BlockPos pos = new BlockPos(Mth.floor((double)dataPos.x), Mth.floor((double)dataPos.y), Mth.floor((double)dataPos.z));
                ResourceKey dataDim = data.getDimension();
                if (dataDim == null) {
                    dataDim = Level.OVERWORLD;
                }
                if ((server = owner.getServer()) == null) {
                    return;
                }
                ServerLevel dogLevel = server.getLevel(dataDim);
                if (dogLevel == null) {
                    return;
                }
                if (dogLevel != sLevel && ((Boolean)ConfigHandler.SERVER.CONDUCTING_BONE_CROSS_ORIGIN.get()).booleanValue()) {
                    DogPromiseManager.addPromiseWithOwner(new DogDistantTeleportToOwnerCrossDimensionPromise(dogUUID, (LivingEntity)owner, pos, dogLevel, sLevel), owner);
                } else {
                    DogPromiseManager.addPromiseWithOwner(new DogDistantTeleportToOwnerPromise(dogUUID, (LivingEntity)owner, pos), owner);
                }
            }
        }
    }

    public static void attemptToTeleportDogToBedOrSendPromise(@Nonnull Dog dog) {
        Optional<BlockPos> bedPos = dog.getBedPos();
        if (!bedPos.isPresent()) {
            return;
        }
        ChunkPos chunkpos = new ChunkPos(bedPos.get());
        LivingEntity owner = dog.getOwner();
        if (dog.level().hasChunk(chunkpos.x, chunkpos.z)) {
            if (DogUtil.isTeleportSafeBlockMidAir(dog, bedPos.get().above())) {
                DogUtil.teleportDogAbs(dog, bedPos.get().above());
                dog.setOrderedToSit(true);
            }
        } else if (owner != null && owner instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)owner;
            DogPromiseManager.addPromiseWithOwner(new DogDistantTeleportToBedPromise(dog), sP);
        }
    }

    public static Dog findBiggestDog(List<Dog> dogs) {
        if (dogs.isEmpty()) {
            return null;
        }
        Dog biggest_dog = dogs.get(0);
        for (Dog dog : dogs) {
            if (dog.getDogSize().getId() <= biggest_dog.getDogSize().getId()) continue;
            biggest_dog = dog;
        }
        return biggest_dog;
    }

    public static boolean isWalkNodeEvaluatorOpenPos(Dog dog, BlockPos pos) {
        return DogNodeEvaluator.dogGetPathTypeFromState((BlockGetter)dog.level(), pos) == PathType.OPEN;
    }

    public static boolean isWalkNodeEvaluatorBlockedPos(Dog dog, BlockPos pos) {
        return DogNodeEvaluator.dogGetPathTypeFromState((BlockGetter)dog.level(), pos) == PathType.BLOCKED;
    }

    public static void teleportDogAbs(Dog dog, BlockPos target) {
        dog.fallDistance = 0.0f;
        dog.moveTo((float)target.getX() + 0.5f, target.getY(), (float)target.getZ() + 0.5f, dog.getYRot(), dog.getXRot());
        dog.getNavigation().stop();
        dog.breakMoveControl();
    }

    public static BlockPos getSurfaceStandingInPos(Dog dog, double x, double z) {
        return BlockPos.containing((double)x, (double)(dog.getY() + 0.5), (double)z);
    }

    public static int getSurfaceStandingInY(Dog dog) {
        return Mth.floor((double)(dog.getY() + 0.5));
    }

    public static boolean playerCanTrainTalent(Player player, Talent talent) {
        if (player != null && player.hasPermissions(4)) {
            return true;
        }
        return ConfigHandler.TALENT.getFlag(talent);
    }

    public static String checkAndCorrectInvalidName(String name) {
        if (name == null) {
            return name;
        }
        String str = name;
        if (str.isEmpty()) {
            return name;
        }
        str = DogUtil.checkFlipName(str);
        str = DogUtil.checkInvalidChar(str);
        str = DogUtil.stripIfNeccessary(str);
        return str;
    }

    private static String stripIfNeccessary(String x) {
        String str = x;
        if (str == null) {
            str = "";
        }
        if (str.isEmpty()) {
            return x;
        }
        if (str.charAt(0) == ' ' || str.charAt(str.length() - 1) == ' ') {
            str = str.strip();
            return str;
        }
        return x;
    }

    private static String checkInvalidChar(String x) {
        String str = x;
        if (str == null) {
            str = "";
        }
        if (str.isEmpty()) {
            return x;
        }
        boolean isInvalidStr = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (DogUtil.isValidChar(Character.valueOf(c))) continue;
            isInvalidStr = true;
            break;
        }
        if (!isInvalidStr) {
            return x;
        }
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!DogUtil.isValidChar(Character.valueOf(c))) continue;
            builder.append(c);
        }
        str = builder.toString();
        return str;
    }

    public static String checkFlipName(String string) {
        if ("Dinnerbone".equals(string) || "Grumm".equals(string)) {
            return "_" + string;
        }
        return string;
    }

    private static boolean isValidChar(Character x) {
        return !INVALID_NAME_CHARS.contains(x) && StringUtil.isAllowedChatCharacter((char)x.charValue());
    }

    public static boolean checkIfOwnerIsLooking(Dog dog, LivingEntity owner) {
        Vec3 v_look_owner = owner.getViewVector(1.0f);
        Vec3 v_look_wanted = dog.getEyePosition().subtract(owner.getEyePosition()).normalize();
        double dot = v_look_wanted.dot(v_look_owner);
        return dot > 0.7;
    }

    public static boolean isTrident(ItemStack stack) {
        return stack.is(Items.TRIDENT);
    }

    public static boolean isDangerPathType(PathType pathType) {
        switch (pathType) {
            case POWDER_SNOW: 
            case DANGER_POWDER_SNOW: 
            case LAVA: 
            case DANGER_FIRE: 
            case DAMAGE_FIRE: 
            case DANGER_OTHER: 
            case DAMAGE_OTHER: 
            case DAMAGE_CAUTIOUS: 
            case DANGER_TRAPDOOR: 
            case TRAPDOOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isScute(ItemStack stack) {
        return ((Ingredient)((ArmorMaterial)ArmorMaterials.ARMADILLO.value()).repairIngredient().get()).test(stack);
    }

    public static int getWolfArmorRepairVal(ItemStack stack) {
        float repair_val = (float)stack.getMaxDamage() * 0.125f;
        return (int)repair_val;
    }

    public static void stopAndForceLook(Dog dog, Vec3 target) {
        dog.setSpeed(0.0f);
        dog.setZza(0.0f);
        dog.lookAt(EntityAnchorArgument.Anchor.EYES, target);
    }

    public static Optional<Dog> getLookingAtDog(Player player, int reach_range) {
        return DogUtil.getLookingAtDog(player, reach_range, filter_dog -> true);
    }

    public static Optional<Dog> getLookingAtDog(Player player, int reach_range, Predicate<Dog> filter) {
        AABB search_area;
        Vec3 view_vec;
        Vec3 max_reach_vec;
        Vec3 max_pos;
        Vec3 eye_pos = player.getEyePosition();
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eye_pos, (Vec3)(max_pos = eye_pos.add(max_reach_vec = (view_vec = player.getViewVector(1.0f)).scale((double)reach_range))), (AABB)(search_area = player.getBoundingBox().expandTowards(max_reach_vec).inflate(1.0, 1.0, 1.0)), e -> {
            Dog dog;
            return e instanceof Dog && filter.test(dog = (Dog)e);
        }, (double)(reach_range * reach_range));
        if (hitResult == null) {
            return Optional.empty();
        }
        Entity entity = hitResult.getEntity();
        if (entity == null) {
            return Optional.empty();
        }
        if (!(entity instanceof Dog)) {
            return Optional.empty();
        }
        Dog dog = (Dog)entity;
        return Optional.of(dog);
    }

    public static boolean checkOwnerByUUID(Dog dog, LivingEntity to_check) {
        if (dog == null || to_check == null) {
            return false;
        }
        UUID dog_owner_id = dog.getOwnerUUID();
        UUID to_check_id = to_check.getUUID();
        if (dog_owner_id == null || to_check_id == null) {
            return false;
        }
        return dog_owner_id.equals(to_check_id);
    }
}

