/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTalents;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.misc.DogArrow;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.talent.doggy_tools.DoggyToolsRangedAttack;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public interface ShootHandler {
    public static final ShootHandler NONE = new ShootHandler(){

        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            return false;
        }
    };
    public static final ShootHandler BOW = new BowlikeShootHandler(){

        @Override
        public boolean isToolReadyToShoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, int tick_using) {
            return tick_using >= 20;
        }

        @Override
        public void shoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, int tick_using) {
            this.shootFromBow(ranged_manager, dog, target, BowItem.getPowerForTime((int)tick_using));
        }

        private void shootFromBow(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, float damage) {
            Optional<AbstractArrow> arrowOptional = this.getAndConsumeDogArrow(dog, damage);
            if (!arrowOptional.isPresent()) {
                return;
            }
            AbstractArrow arrow = arrowOptional.get();
            ranged_manager.shootProjectile(dog, (Projectile)arrow, target, SoundEvents.SKELETON_SHOOT);
        }

        public Optional<AbstractArrow> getAndConsumeDogArrow(AbstractDog dog, float damage) {
            Optional<AbstractArrow> projArrowOptional;
            ItemStack bowStack = dog.getMainHandItem();
            if (!(bowStack.getItem() instanceof BowItem)) {
                return Optional.empty();
            }
            Optional<Pair<ItemStackHandler, Integer>> arrowInvOptional = DoggyToolsRangedAttack.findArrowsInInventory(dog);
            ItemStackHandler inv = null;
            int id = -1;
            if (arrowInvOptional.isPresent()) {
                inv = (ItemStackHandler)arrowInvOptional.get().getLeft();
                id = (Integer)arrowInvOptional.get().getRight();
            }
            ItemStack arrow_stack = ItemStack.EMPTY;
            if (inv != null && id >= 0) {
                arrow_stack = inv.getStackInSlot(id).copy();
            }
            if (!(projArrowOptional = this.getArrowFromBow(dog, bowStack, arrow_stack, damage)).isPresent()) {
                return Optional.empty();
            }
            this.consumeArrow(dog, bowStack, arrow_stack);
            if (inv != null && id >= 0) {
                inv.setStackInSlot(id, arrow_stack);
            }
            bowStack.hurtAndBreak(1, (LivingEntity)dog, EquipmentSlot.MAINHAND);
            return projArrowOptional;
        }

        private Optional<AbstractArrow> getArrowFromBow(AbstractDog dog, ItemStack bow_stack, ItemStack arrowStack, float power) {
            boolean flaming_arrow;
            Item item;
            Item item2 = bow_stack.getItem();
            if (!(item2 instanceof BowItem)) {
                return Optional.empty();
            }
            BowItem bow = (BowItem)item2;
            boolean is_infinity_bow = DoggyToolsRangedAttack.isInfinityBow(bow_stack, dog);
            ItemStack select_arrowStack = null;
            Item select_arrow = null;
            if (is_infinity_bow) {
                select_arrow = Items.ARROW;
                select_arrowStack = new ItemStack((ItemLike)select_arrow);
            }
            if ((item = arrowStack.getItem()) instanceof ArrowItem) {
                ArrowItem arrowItem = (ArrowItem)item;
                select_arrow = arrowItem;
                select_arrowStack = arrowStack;
            }
            if (select_arrowStack == null || select_arrowStack.isEmpty()) {
                return Optional.empty();
            }
            if (!(select_arrow instanceof ArrowItem)) {
                return Optional.empty();
            }
            ArrowItem arrow = (ArrowItem)select_arrow;
            arrowStack = select_arrowStack;
            AbstractArrow arrow_proj = this.createDogArrow(dog, arrow, arrowStack, bow_stack);
            if (arrow_proj == null) {
                return Optional.empty();
            }
            arrow_proj = bow.customArrow(arrow_proj, arrowStack, bow_stack);
            if (power >= 1.0f) {
                arrow_proj.setCritArrow(true);
            }
            boolean bl = flaming_arrow = dog.getDogLevel(DoggyTalents.HELL_HOUND) >= 5;
            if (flaming_arrow) {
                EntityUtil.setSecondsOnFire((Entity)arrow_proj, 100);
            }
            arrow_proj.pickup = is_infinity_bow ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
            return Optional.of(arrow_proj);
        }

        private AbstractArrow createDogArrow(AbstractDog dog, ArrowItem arrow_item, ItemStack arrow_stack, ItemStack bow_stack) {
            if (((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BOW_VANILLA_PROJ.get()).booleanValue()) {
                return arrow_item.createArrow(dog.level(), arrow_stack, (LivingEntity)dog, bow_stack);
            }
            return new DogArrow(dog.level(), dog, arrow_stack.copyWithCount(1), bow_stack.copyWithCount(1));
        }

        private void consumeArrow(AbstractDog dog, ItemStack bow_stack, ItemStack arrowStack) {
            boolean is_infinity_bow = DoggyToolsRangedAttack.isInfinityBow(bow_stack, dog);
            if (!is_infinity_bow) {
                arrowStack.shrink(1);
            }
        }
    };
    public static final ShootHandler TRIDENT = new BowlikeShootHandler(){

        @Override
        public boolean isToolReadyToShoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, int tick_using) {
            return tick_using >= 20 && !ranged_manager.hasAwaitingTrident();
        }

        @Override
        public void shoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, int tick_using) {
            this.shootFromTrident(ranged_manager, dog, target);
        }

        private void shootFromTrident(DoggyToolsRangedAttack ranged_manager, AbstractDog ddog, LivingEntity target) {
            boolean flaming_trident;
            if (!(ddog instanceof Dog)) {
                return;
            }
            Dog dog = (Dog)ddog;
            Optional<DogThrownTrident> tridentOptional = this.getAndConsumeDogTrident(dog);
            if (!tridentOptional.isPresent()) {
                return;
            }
            DogThrownTrident trident = tridentOptional.get();
            boolean bl = flaming_trident = dog.getDogLevel(DoggyTalents.HELL_HOUND) >= 5;
            if (flaming_trident) {
                EntityUtil.setSecondsOnFire((Entity)trident, 100);
            }
            ranged_manager.shootProjectile(dog, (Projectile)trident, target, (SoundEvent)SoundEvents.TRIDENT_THROW.value());
            ranged_manager.setAwaitingTrident(trident);
        }

        private Optional<DogThrownTrident> getAndConsumeDogTrident(Dog dog) {
            ItemStack trident_stack = dog.getMainHandItem();
            if (!DogUtil.isTrident(trident_stack)) {
                return Optional.empty();
            }
            DogThrownTrident proj = new DogThrownTrident(dog, trident_stack.copy());
            proj.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            trident_stack.hurtAndBreak(1, (LivingEntity)dog, EquipmentSlot.MAINHAND);
            return Optional.of(proj);
        }
    };
    public static final ShootHandler CROSSBOW = new ShootHandler(){

        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            AbstractDog dog = ctx.dog;
            ItemStack crossbow_stack = dog.getMainHandItem();
            if (!(crossbow_stack.getItem() instanceof CrossbowItem)) {
                if (dog.isUsingItem()) {
                    dog.stopUsingItem();
                }
                return false;
            }
            Optional<Pair<ItemStackHandler, Integer>> arrow_optional = DoggyToolsRangedAttack.findArrowsInInventory(dog);
            if (!arrow_optional.isPresent()) {
                if (dog.isUsingItem()) {
                    dog.stopUsingItem();
                }
                return false;
            }
            Pair<ItemStackHandler, Integer> arrow_stack = arrow_optional.get();
            boolean attack_result = false;
            if (this.isCrossbowCharged(crossbow_stack)) {
                attack_result = this.updateCrossbowAttack(ranged_manager, dog, ctx.target, crossbow_stack);
            } else {
                this.updateChargeCrossbow(ranged_manager, dog, crossbow_stack, arrow_stack, ctx);
            }
            return attack_result;
        }

        private boolean isCrossbowCharged(ItemStack crossbow_stack) {
            return CrossbowItem.isCharged((ItemStack)crossbow_stack);
        }

        private void updateChargeCrossbow(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, ItemStack crossbow_stack, Pair<ItemStackHandler, Integer> arrow_getter, IDogRangedAttackManager.UsingWeaponContext ctx) {
            boolean should_stop_using;
            ranged_manager.setDelayedCrossbowAttack(10);
            if (!dog.isUsingItem()) {
                this.mayStartUsingWeapon(ctx);
                return;
            }
            boolean bl = should_stop_using = !ctx.canSeeTarget && ctx.seeTime < -60;
            if (should_stop_using) {
                dog.stopUsingItem();
                return;
            }
            int using_tick = dog.getTicksUsingItem();
            if (using_tick >= CrossbowItem.getChargeDuration((ItemStack)crossbow_stack, (LivingEntity)dog)) {
                dog.stopUsingItem();
                this.chargeCrossbowAndConsumeArrow(dog, crossbow_stack, arrow_getter);
            }
        }

        private void chargeCrossbowAndConsumeArrow(AbstractDog dog, ItemStack crossbow_stack, Pair<ItemStackHandler, Integer> arrow_getter) {
            ItemStackHandler inv = null;
            int id = -1;
            inv = (ItemStackHandler)arrow_getter.getLeft();
            id = (Integer)arrow_getter.getRight();
            ItemStack arrow_stack = ItemStack.EMPTY;
            if (inv != null && id >= 0) {
                arrow_stack = inv.getStackInSlot(id).copy();
            }
            if (arrow_stack.isEmpty()) {
                return;
            }
            boolean is_multishot = ItemUtil.getEnchantmentLevelForItem((ResourceKey<Enchantment>)Enchantments.MULTISHOT, dog.registryAccess(), crossbow_stack) > 0;
            int shoot_amount = is_multishot ? 3 : 1;
            ArrayList<ItemStack> item_list = new ArrayList<ItemStack>(shoot_amount);
            for (int i = 0; i < shoot_amount; ++i) {
                item_list.add(arrow_stack.copyWithCount(1));
            }
            if (item_list.isEmpty()) {
                return;
            }
            crossbow_stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(item_list));
            if (inv != null) {
                arrow_stack = arrow_stack.copy();
                arrow_stack.shrink(1);
                inv.setStackInSlot(id, arrow_stack);
            }
            dog.playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), 1.0f, 1.0f / (dog.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }

        private boolean updateCrossbowAttack(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, ItemStack crossbow_stack) {
            ranged_manager.decDelayedCrossbowAttack();
            if (ranged_manager.getDelayedCrossbowAttack() <= 0) {
                ranged_manager.setDelayedCrossbowAttack(20);
                this.shootViaCrossbow(dog, target, crossbow_stack);
                return true;
            }
            return false;
        }

        private void shootViaCrossbow(AbstractDog dog, LivingEntity target, ItemStack crossbow_stack) {
            Item item = crossbow_stack.getItem();
            if (!(item instanceof CrossbowItem)) {
                return;
            }
            CrossbowItem crossbowitem = (CrossbowItem)item;
            crossbowitem.performShooting(dog.level(), (LivingEntity)dog, InteractionHand.MAIN_HAND, crossbow_stack, 1.6f, 2.0f, target);
            this.hellHoundSetFireToOwnedArrows(dog);
        }

        private boolean hellHoundSetFireToOwnedArrows(AbstractDog dog) {
            if (!dog.fireImmune()) {
                return false;
            }
            Predicate<AbstractArrow> is_target_arrow = e -> {
                if (!e.isAlive()) {
                    return false;
                }
                return e.getOwner() == dog;
            };
            AABB bb = dog.getBoundingBox().inflate(1.0);
            List targets = dog.level().getEntitiesOfClass(AbstractArrow.class, bb, is_target_arrow);
            if (targets.isEmpty()) {
                return false;
            }
            for (AbstractArrow target : targets) {
                EntityUtil.setSecondsOnFire((Entity)target, 20);
            }
            return true;
        }

        private void mayStartUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
            if (ctx.cooldown <= 0 && ctx.seeTime >= -60) {
                ctx.dog.startUsingItem(InteractionHand.MAIN_HAND);
            }
        }
    };

    public boolean updateUsingWeapon(DoggyToolsRangedAttack var1, IDogRangedAttackManager.UsingWeaponContext var2);

    public static abstract class BowlikeShootHandler
    implements ShootHandler {
        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            int using_tick;
            boolean should_stop_using;
            AbstractDog dog = ctx.dog;
            if (!dog.isUsingItem()) {
                this.mayStartUsingWeapon(ctx);
                return false;
            }
            boolean bl = should_stop_using = !ctx.canSeeTarget && ctx.seeTime < -60;
            if (should_stop_using) {
                dog.stopUsingItem();
                return false;
            }
            if (ctx.canSeeTarget && this.isToolReadyToShoot(ranged_manager, dog, using_tick = dog.getTicksUsingItem())) {
                dog.stopUsingItem();
                this.shoot(ranged_manager, dog, ctx.target, using_tick);
                return true;
            }
            return false;
        }

        private void mayStartUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
            if (ctx.cooldown <= 0 && ctx.seeTime >= -60) {
                ctx.dog.startUsingItem(InteractionHand.MAIN_HAND);
            }
        }

        public abstract boolean isToolReadyToShoot(DoggyToolsRangedAttack var1, AbstractDog var2, int var3);

        public abstract void shoot(DoggyToolsRangedAttack var1, AbstractDog var2, LivingEntity var3, int var4);
    }
}

