/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTalents;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.ShootHandler;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.ItemUtil;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DoggyToolsRangedAttack
implements IDogRangedAttackManager {
    private Optional<DogThrownTrident> awaitingTrident = Optional.empty();
    private int delayedCrossbowAttack;

    @Override
    public boolean isApplicable(AbstractDog dog) {
        return DoggyToolsRangedAttack.getActiveShootHandler(dog) != ShootHandler.NONE;
    }

    @Override
    public boolean updateUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
        this.validateAwaitingTrident();
        ShootHandler handler = DoggyToolsRangedAttack.getActiveShootHandler(ctx.dog);
        return handler.updateUsingWeapon(this, ctx);
    }

    public void shootProjectile(AbstractDog dog, Projectile proj, LivingEntity target, SoundEvent shoot_sound) {
        double aim_y_offset_l_xz_influence = 0.2;
        double aim_y_offset_l_xz_influence_down = 0.1;
        double dx = target.getX() - dog.getX();
        double dz = target.getZ() - dog.getZ();
        double l_xz = Math.sqrt(dx * dx + dz * dz);
        double aim_y = target.getY() + 0.5 * (double)target.getBbHeight();
        double dy = aim_y - proj.getY();
        dy = dy > 0.0 ? (dy += l_xz * 0.2) : (dy += l_xz * 0.1);
        double shoot_dir_x = dx;
        double shoot_dir_y = dy;
        double shoot_dir_z = dz;
        float power = 1.6f;
        float error_window = 2.0f;
        proj.shoot(shoot_dir_x, shoot_dir_y, shoot_dir_z, power, error_window);
        dog.playSound(shoot_sound, 1.0f, 1.0f / (dog.getRandom().nextFloat() * 0.4f + 0.8f));
        dog.level().addFreshEntity((Entity)proj);
    }

    @Override
    public void onStop(AbstractDog dog) {
        dog.stopUsingItem();
        this.awaitingTrident = Optional.empty();
    }

    private void validateAwaitingTrident() {
        if (this.awaitingTrident == null) {
            return;
        }
        if (!this.awaitingTrident.isPresent()) {
            return;
        }
        DogThrownTrident trident = this.awaitingTrident.get();
        if (!trident.isAlive()) {
            this.awaitingTrident = Optional.empty();
            return;
        }
    }

    public boolean hasAwaitingTrident() {
        return this.awaitingTrident != null && this.awaitingTrident.isPresent();
    }

    public void setAwaitingTrident(DogThrownTrident trident) {
        this.awaitingTrident = Optional.ofNullable(trident);
    }

    public void decDelayedCrossbowAttack() {
        if (this.delayedCrossbowAttack > 0) {
            --this.delayedCrossbowAttack;
        }
    }

    public void setDelayedCrossbowAttack(int x) {
        this.delayedCrossbowAttack = x;
    }

    public int getDelayedCrossbowAttack() {
        return this.delayedCrossbowAttack;
    }

    public static boolean isTridentAndEligible(AbstractDog dog, ItemStack stack) {
        if (!DogUtil.isTrident(stack)) {
            return false;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_USE_TRIDENT.get()).booleanValue()) {
            return false;
        }
        Level level = dog.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sLevel = (ServerLevel)level;
        return ItemUtil.getEnchantmentLevelForItem((ResourceKey<Enchantment>)Enchantments.LOYALTY, dog.registryAccess(), stack) >= 2;
    }

    public static Optional<Pair<ItemStackHandler, Integer>> findArrowsInInventory(AbstractDog dog) {
        Optional talentInstOptional = dog.getTalent(DoggyTalents.DOGGY_TOOLS);
        if (!talentInstOptional.isPresent()) {
            return Optional.empty();
        }
        Object t = talentInstOptional.get();
        if (!(t instanceof DoggyToolsTalent)) {
            return Optional.empty();
        }
        DoggyToolsTalent tools = (DoggyToolsTalent)t;
        ItemStackHandler inv = tools.getTools();
        int id = DoggyToolsRangedAttack.findArrowStackInInventory(inv);
        if (id >= 0) {
            return Optional.of(Pair.of((Object)inv, (Object)id));
        }
        talentInstOptional = dog.getTalent(DoggyTalents.PACK_PUPPY);
        if (!talentInstOptional.isPresent()) {
            return Optional.empty();
        }
        Object t2 = talentInstOptional.get();
        if (!(t2 instanceof PackPuppyTalent)) {
            return Optional.empty();
        }
        PackPuppyTalent packPup = (PackPuppyTalent)t2;
        inv = packPup.inventory();
        id = DoggyToolsRangedAttack.findArrowStackInInventory(inv);
        if (id >= 0) {
            return Optional.of(Pair.of((Object)inv, (Object)id));
        }
        return Optional.empty();
    }

    private static int findArrowStackInInventory(ItemStackHandler inv) {
        if (inv == null) {
            return -1;
        }
        int selected_id = -1;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!(stack.getItem() instanceof ArrowItem)) continue;
            selected_id = i;
            break;
        }
        return selected_id;
    }

    public static boolean isInfinityBow(ItemStack bowStack, AbstractDog dog) {
        Level level = dog.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sLevel = (ServerLevel)level;
        return ItemUtil.getEnchantmentLevelForItem((ResourceKey<Enchantment>)Enchantments.INFINITY, dog.registryAccess(), bowStack) > 0;
    }

    public static ShootHandler getActiveShootHandler(AbstractDog dog) {
        ItemStack mainhand_item = dog.getMainHandItem();
        return DoggyToolsRangedAttack.getShootHandler(mainhand_item, dog);
    }

    public static ShootHandler getShootHandler(ItemStack stack, AbstractDog dog) {
        boolean eligible;
        if (stack.isEmpty()) {
            return ShootHandler.NONE;
        }
        if (stack.getItem() instanceof BowItem) {
            boolean bl = eligible = DoggyToolsRangedAttack.isInfinityBow(stack, dog) || DoggyToolsRangedAttack.findArrowsInInventory(dog).isPresent();
            if (eligible) {
                return ShootHandler.BOW;
            }
        }
        if (stack.getItem() instanceof CrossbowItem && (eligible = DoggyToolsRangedAttack.findArrowsInInventory(dog).isPresent())) {
            return ShootHandler.CROSSBOW;
        }
        if (DoggyToolsRangedAttack.isTridentAndEligible(dog, stack)) {
            return ShootHandler.TRIDENT;
        }
        return ShootHandler.NONE;
    }
}

