/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.item.ScentTreatItem;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.NBTUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SnifferDogTalent
extends TalentInstance {
    private Block detectingBlock = Blocks.AIR;
    private Optional<BlockPos> suspiciousPos = Optional.empty();
    private int dontNotifyOwnerAgainTick = 0;
    private int tickTillDetect = 5;

    public SnifferDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.level().isClientSide) {
            return;
        }
        if (!dogIn.isDoingFine()) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (this.dontNotifyOwnerAgainTick > 0) {
            --this.dontNotifyOwnerAgainTick;
        }
        this.validateSuspiciousPos(dog);
        if (!this.suspiciousPos.isPresent() && !dog.isInSittingPose() && this.detectingBlock != Blocks.AIR) {
            this.detectBlocksAround(dog);
        }
        if (dog.isBusy()) {
            return;
        }
        if (this.suspiciousPos.isPresent() && this.dontNotifyOwnerAgainTick <= 0) {
            this.notifyOwner(dog);
        }
    }

    private void detectBlocksAround(Dog dog) {
        if (--this.tickTillDetect > 0) {
            return;
        }
        this.tickTillDetect = 10;
        this.doDetectBlockAround(dog);
    }

    private void doDetectBlockAround(Dog dog) {
        BlockPos dog_b0 = dog.blockPosition();
        int radius = this.getDetectRadius(dog);
        int start = 0;
        while (start + 2 <= radius) {
            for (int i = 0; i < 10; ++i) {
                RandomSource r = dog.getRandom();
                int offSmall = 2;
                int offLarge = start + 2;
                int r1 = r.nextIntBetweenInclusive(-offLarge, offLarge);
                int r2 = r.nextIntBetweenInclusive(-offSmall, offSmall);
                r2 += Mth.sign((double)r2) * start;
                int randXOff = r1;
                int randZOff = r2;
                if (r.nextBoolean()) {
                    randXOff = r2;
                    randZOff = r1;
                }
                int randYOff = r.nextIntBetweenInclusive(-3, 3);
                BlockPos rand_b0 = dog_b0.offset(new Vec3i(randXOff, randYOff, randZOff));
                BlockState state = dog.level().getBlockState(rand_b0);
                if (state.getBlock() != this.detectingBlock) continue;
                this.suspiciousPos = Optional.of(rand_b0);
                return;
            }
            start += 2;
        }
    }

    private int getDetectRadius(Dog dog) {
        if (this.level() >= 5) {
            return 28;
        }
        if (this.level() < 0) {
            return 0;
        }
        switch (this.level()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 22;
            }
        }
        return 8;
    }

    public void setDetectBlock(Block block) {
        this.detectingBlock = block;
        if (block == null || block instanceof AirBlock) {
            this.detectingBlock = Blocks.AIR;
        }
    }

    public void clearDetectBlock() {
        this.detectingBlock = Blocks.AIR;
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!stack.is(DoggyItems.SCENT_TREAT.get())) {
            return InteractionResult.PASS;
        }
        if (dog.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (playerIn.isShiftKeyDown()) {
            if (this.detectingBlock == null) {
                this.detectingBlock = Blocks.AIR;
            }
            MutableComponent c1 = this.detectingBlock == Blocks.AIR ? Component.translatable((String)"talent.doggytalents.sniffer_dog.detecting_block_status.none") : Component.translatable((String)"talent.doggytalents.sniffer_dog.detecting_block_status", (Object[])new Object[]{dog.getName().getString(), Component.translatable((String)this.detectingBlock.asItem().getDescriptionId()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)))});
            playerIn.sendSystemMessage((Component)c1);
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        if (!tag.contains(ScentTreatItem.SCENT_BLOCK_ID)) {
            this.clearDetectBlock();
        } else {
            Block block = (Block)NBTUtil.getRegistryValue(tag, ScentTreatItem.SCENT_BLOCK_ID, BuiltInRegistries.BLOCK);
            if (block == null) {
                return InteractionResult.SUCCESS;
            }
            this.setDetectBlock(block);
        }
        dog.playSound(SoundEvents.INK_SAC_USE, 1.0f, 1.0f);
        ItemStack retItem = new ItemStack((ItemLike)DoggyItems.DROOL_SCENT_TREAT.get());
        if (ItemUtil.hasTag(stack)) {
            ItemUtil.copyTag(stack, retItem);
        }
        dog.spawnAtLocation(retItem);
        stack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public void validateSuspiciousPos(Dog dog) {
        if (!this.suspiciousPos.isPresent()) {
            return;
        }
        BlockPos pos = this.suspiciousPos.get();
        BlockState state = dog.level().getBlockState(pos);
        if (!state.is(this.detectingBlock)) {
            this.suspiciousPos = Optional.empty();
        }
    }

    public void notifyOwner(Dog dog) {
        LivingEntity owner = dog.getOwner();
        if (owner == null) {
            return;
        }
        if (owner.distanceToSqr((Entity)dog) > 64.0) {
            return;
        }
        if (!dog.canDoIdileAnim()) {
            return;
        }
        dog.triggerAction(new DogGetOwnerAttentionAndInformAction(dog, owner, this));
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        if (this.detectingBlock == null) {
            this.detectingBlock = Blocks.AIR;
        }
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)this.detectingBlock);
        NBTUtil.putResourceLocation(compound, "snifferDog_detectingBlock", id);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        Block block = (Block)NBTUtil.getRegistryValue(compound, "snifferDog_detectingBlock", BuiltInRegistries.BLOCK);
        if (block == null) {
            block = Blocks.AIR;
        }
        this.detectingBlock = block;
    }

    public static class DogGetOwnerAttentionAndInformAction
    extends TriggerableAction {
        private SnifferDogTalent inst;
        private LivingEntity owner;
        private boolean isPointingToPos = false;
        private int timeOutTick = 0;
        private boolean notifiedOwner = false;
        private BlockPos targetPos;
        private int tickLookLeft = 0;
        private int tickAnim = 0;
        private DogAnimation currentAnimation = DogAnimation.SNIFFER_DOG_POINT_STRAIGHT;

        public DogGetOwnerAttentionAndInformAction(Dog dog, LivingEntity owner, SnifferDogTalent inst) {
            super(dog, false, false);
            this.inst = inst;
            this.owner = owner;
        }

        @Override
        public void onStart() {
            this.isPointingToPos = false;
            this.notifiedOwner = false;
            this.timeOutTick = 400 + this.dog.getRandom().nextInt(6) * 20;
            this.targetPos = this.inst.suspiciousPos.orElse(null);
            this.tickLookLeft = 10;
            this.tickAnim = 0;
        }

        @Override
        public void tick() {
            if (!this.owner.isAlive() || this.owner.isSpectator()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.owner.distanceToSqr((Entity)this.dog) > 144.0) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.invalidateTargetPos();
            if (this.targetPos == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.isPointingToPos) {
                --this.timeOutTick;
                if (this.timeOutTick <= 0) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            } else {
                boolean anim_end_or_interupted;
                boolean bl = anim_end_or_interupted = this.tickAnim >= this.currentAnimation.getLengthTicks() || this.dog.getAnim() != this.currentAnimation || !this.dog.onGround();
                if (this.tickLookLeft <= 0 && anim_end_or_interupted) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            }
            if (this.isPointingToPos) {
                this.pointsTowardThePos();
            } else {
                this.getOwnerAttention();
            }
        }

        private void invalidateTargetPos() {
            if (this.targetPos == null) {
                return;
            }
            if (!this.inst.suspiciousPos.isPresent()) {
                this.targetPos = null;
                return;
            }
            if (!this.inst.suspiciousPos.get().equals((Object)this.targetPos)) {
                this.targetPos = null;
                return;
            }
        }

        private void getOwnerAttention() {
            if (this.targetPos == null) {
                return;
            }
            this.dog.getLookControl().setLookAt((Entity)this.owner);
            if (!this.notifiedOwner) {
                this.notifiedOwner = true;
                this.notifyOwner(this.dog, this.owner, this.dog.distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPos)));
                this.moveBackIfNeeded(this.dog, this.targetPos);
            }
            if (this.dog.distanceToSqr((Entity)this.owner) > 16.0) {
                return;
            }
            if (!this.checkIfCanSeeOwner(this.dog, this.owner)) {
                return;
            }
            if (DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
                this.isPointingToPos = true;
            }
        }

        private void pointsTowardThePos() {
            if (this.targetPos == null) {
                return;
            }
            this.dog.getLookControl().setLookAt(Vec3.atCenterOf((Vec3i)this.targetPos));
            if (this.tickLookLeft > 0) {
                --this.tickLookLeft;
                if (this.tickLookLeft <= 0) {
                    this.currentAnimation = this.pickAnim(this.dog, this.targetPos);
                    this.dog.setAnim(this.currentAnimation);
                }
                return;
            }
            ++this.tickAnim;
        }

        private void moveBackIfNeeded(Dog dog, BlockPos pos) {
            Vec3 v_dog_pos = Vec3.atBottomCenterOf((Vec3i)pos).subtract(dog.position());
            Vec3 v_dog_pos_xz = new Vec3(v_dog_pos.x, 0.0, v_dog_pos.z).normalize();
            Vec3 wantedStandPos = Vec3.atBottomCenterOf((Vec3i)dog.blockPosition()).subtract(v_dog_pos_xz.scale(0.5));
            dog.getMoveControl().setWantedPosition(wantedStandPos.x, wantedStandPos.y, wantedStandPos.z, 0.5);
        }

        private DogAnimation pickAnim(Dog dog, BlockPos pos) {
            Vec3 v_dog_pos = Vec3.atCenterOf((Vec3i)pos).subtract(dog.getEyePosition());
            if (v_dog_pos.y < -1.0) {
                return DogAnimation.SNIFFER_DOG_POINT_DOWNARD;
            }
            if (v_dog_pos.y > 1.0) {
                return DogAnimation.SNIFFER_DOG_POINT_UPWARD;
            }
            return DogAnimation.SNIFFER_DOG_POINT_STRAIGHT;
        }

        private void notifyOwner(Dog dog, LivingEntity owner, double distanceAwaySqr) {
            MutableComponent c1 = Component.translatable((String)this.getStringStatus(dog, distanceAwaySqr), (Object[])new Object[]{dog.getName().getString()});
            owner.sendSystemMessage((Component)c1);
            if (distanceAwaySqr <= 64.0) {
                SoundEvent sound = dog.dogMood.getSnifferDogForteSound();
                dog.playSound(sound, 1.0f, 1.0f);
            } else {
                SoundEvent sound = dog.dogMood.getSnifferDogPianoSound();
                dog.playSound(sound, 1.0f, 1.5f);
            }
        }

        private String getStringStatus(Dog dog, double distanceAwaySqr) {
            int r = dog.getRandom().nextInt(3);
            String posfix = ".mid";
            if (distanceAwaySqr > 256.0) {
                posfix = ".far";
            } else if (distanceAwaySqr <= 64.0) {
                posfix = ".near";
            }
            return "talent.doggytalents.sniffer_dog.notify_owner." + r + posfix;
        }

        private boolean checkIfCanSeeOwner(Dog dog, LivingEntity owner) {
            if (dog.tickCount % 5 != 0) {
                return false;
            }
            return dog.getSensing().hasLineOfSight((Entity)owner);
        }

        @Override
        public void onStop() {
            this.inst.suspiciousPos = Optional.empty();
            this.inst.dontNotifyOwnerAgainTick = (5 + this.dog.getRandom().nextInt(10)) * 20;
        }
    }
}

