/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogEatingParticleData;
import doggytalents.common.network.packet.data.DogShakingData;
import doggytalents.common.network.packet.data.ParticleData;
import doggytalents.common.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class ParticlePackets {

    public static class DogShakingPacket
    implements IPacket<DogShakingData> {
        @Override
        public void encode(DogShakingData data, FriendlyByteBuf buf) {
            buf.writeInt(data.dogId);
            buf.writeByte((byte)data.state.getId());
        }

        @Override
        public DogShakingData decode(FriendlyByteBuf buf) {
            int dogId = buf.readInt();
            DogShakingData.State state = DogShakingData.State.fromId(buf.readByte());
            return new DogShakingData(dogId, state);
        }

        @Override
        public void handle(DogShakingData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Minecraft mc = Minecraft.getInstance();
                    Entity e = mc.level.getEntity(data.dogId);
                    if (e instanceof Dog) {
                        Dog d = (Dog)e;
                        d.handleDogShakingUpdate(data.state);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogShakingPacket(AbstractDog dog, DogShakingData.State state) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> dog), new DogShakingData(dog.getId(), state));
        }
    }

    public static class DogEatingParticlePacket
    implements IPacket<DogEatingParticleData> {
        @Override
        public void encode(DogEatingParticleData data, FriendlyByteBuf buf) {
            buf.writeInt(data.dogId);
            NetworkUtil.writeItemToBuf(buf, data.food);
        }

        @Override
        public DogEatingParticleData decode(FriendlyByteBuf buf) {
            int dogId = buf.readInt();
            ItemStack food = NetworkUtil.readItemFromBuf(buf);
            return new DogEatingParticleData(dogId, food);
        }

        @Override
        public void handle(DogEatingParticleData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Minecraft mc = Minecraft.getInstance();
                    Entity e = mc.level.getEntity(data.dogId);
                    if (e instanceof Dog) {
                        Dog dog = (Dog)e;
                        if (data.food != null) {
                            float a1 = dog.getClientAnimatedYBodyRotInRadians();
                            double dx1 = (double)(-Mth.sin((float)a1)) * ((double)dog.getDogVisualBbWidth() * 1.5);
                            double dz1 = (double)Mth.cos((float)a1) * ((double)dog.getDogVisualBbWidth() * 1.5);
                            for (int i = 0; i < 15; ++i) {
                                double d1 = mc.level.getRandom().nextGaussian() * 0.5;
                                double d3 = mc.level.getRandom().nextGaussian() * 0.8;
                                double d5 = mc.level.getRandom().nextGaussian() * 0.5;
                                double d6 = mc.level.getRandom().nextGaussian() * 0.1;
                                double d7 = mc.level.getRandom().nextGaussian() * 0.1;
                                double d8 = mc.level.getRandom().nextGaussian() * 0.1;
                                mc.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, data.food), dog.getX() + dx1 + d1, dog.getY() + (double)dog.getEyeHeight() + d3, dog.getZ() + dz1 + d5, d6, d7, d8);
                            }
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogEatingParticlePacketToNearby(AbstractDog dog, ItemStack food) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> dog), new DogEatingParticleData(dog.getId(), food));
        }
    }

    public static class CritEmitterPacket
    implements IPacket<ParticleData.CritEmitterData> {
        @Override
        public void encode(ParticleData.CritEmitterData data, FriendlyByteBuf buf) {
            buf.writeInt(data.targetId);
        }

        @Override
        public ParticleData.CritEmitterData decode(FriendlyByteBuf buf) {
            return new ParticleData.CritEmitterData(buf.readInt());
        }

        @Override
        public void handle(ParticleData.CritEmitterData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Minecraft mc = Minecraft.getInstance();
                    Entity e = mc.level.getEntity(data.targetId);
                    if (e != null) {
                        Minecraft.getInstance().particleEngine.createTrackingEmitter(e, (ParticleOptions)ParticleTypes.CRIT);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendCritEmitterPacketToNearClients(Entity e) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), new ParticleData.CritEmitterData(e.getId()));
        }
    }
}

