/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogInventoryPageData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DogInventoryPagePacket
implements IPacket<DogInventoryPageData> {
    @Override
    public DogInventoryPageData decode(FriendlyByteBuf buf) {
        return new DogInventoryPageData(buf.readInt());
    }

    @Override
    public void encode(DogInventoryPageData data, FriendlyByteBuf buf) {
        buf.writeInt(data.page);
    }

    @Override
    public void handle(DogInventoryPageData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                ServerPlayer player = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                AbstractContainerMenu container = player.containerMenu;
                if (container instanceof DogInventoriesContainer) {
                    DogInventoriesContainer inventories = (DogInventoriesContainer)container;
                    int maxViewOffset = Math.max(0, inventories.getTotalNumColumns() - 9);
                    int newViewOffset = Mth.clamp((int)data.page, (int)0, (int)maxViewOffset);
                    inventories.setViewOffset(newViewOffset);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

