/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogIncapMsgData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class DogIncapMsgPackets {

    public static class Response
    implements IPacket<DogIncapMsgData.Response> {
        @Override
        public void encode(DogIncapMsgData.Response data, FriendlyByteBuf buf) {
            buf.writeInt(data.entityId);
            buf.writeUtf(data.msg, 256);
        }

        @Override
        public DogIncapMsgData.Response decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            String msg = buf.readUtf(256);
            return new DogIncapMsgData.Response(msg, id);
        }

        @Override
        public void handle(DogIncapMsgData.Response data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Minecraft mc = Minecraft.getInstance();
                    Entity e = mc.level.getEntity(data.entityId);
                    if (e instanceof Dog) {
                        Dog d = (Dog)e;
                        d.incapacitatedMananger.setIncapMsg(data.msg);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class Request
    extends DogPacket<DogIncapMsgData.Request> {
        @Override
        public DogIncapMsgData.Request decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            return new DogIncapMsgData.Request(id);
        }

        @Override
        public void handleDog(Dog dog, DogIncapMsgData.Request data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            if (dog.level().isClientSide) {
                return;
            }
            ServerPlayer sender = ctx.get().getSender();
            if (dog.getOwner() != sender) {
                return;
            }
            String msg = dog.incapacitatedMananger.getIncapMsg();
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new DogIncapMsgData.Response(msg, dog.getId()));
        }
    }
}

