/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.ChangeArtifactData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChangeArtifactPacket
extends DogPacket<ChangeArtifactData> {
    @Override
    public void encode(ChangeArtifactData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.add);
        buf.writeInt(data.slotId);
    }

    @Override
    public ChangeArtifactData decode(FriendlyByteBuf buf) {
        int dog_id = buf.readInt();
        boolean add = buf.readBoolean();
        int slot_id = buf.readInt();
        return new ChangeArtifactData(dog_id, add, slot_id);
    }

    @Override
    public void handleDog(Dog dog, ChangeArtifactData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (!dog.canInteract((LivingEntity)sender)) {
            return;
        }
        if (data.add) {
            DoggyArtifactItem artifact;
            Inventory inventory = sender.getInventory();
            NonNullList items = inventory.items;
            if (data.slotId < 0 || data.slotId >= items.size()) {
                return;
            }
            ItemStack item = (ItemStack)items.get(data.slotId);
            Item item2 = item.getItem();
            if (item2 instanceof DoggyArtifactItem && dog.addArtifact(artifact = (DoggyArtifactItem)item2)) {
                dog.consumeItemFromStack((Entity)dog, item);
            }
        } else {
            List<DoggyArtifactItem> artifacts = dog.getArtifactsList();
            if (data.slotId < 0 || data.slotId >= artifacts.size()) {
                return;
            }
            DoggyArtifactItem toRemove = artifacts.get(data.slotId);
            if (toRemove == null) {
                return;
            }
            Inventory inventory = sender.getInventory();
            if (inventory.getFreeSlot() < 0) {
                return;
            }
            ItemStack retItem = new ItemStack((ItemLike)toRemove);
            inventory.add(retItem);
            dog.removeArtifact(data.slotId);
        }
    }
}

