/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.client.entity.render.world.CanineTrackerLocateRenderer;
import doggytalents.client.screen.CanineTrackerScreen;
import doggytalents.common.item.CanineTrackerItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class CanineTrackerPackets {

    public static class ResponsePosUpdatePacket
    implements IPacket<CanineTrackerData.ResponsePosUpdateData> {
        @Override
        public void encode(CanineTrackerData.ResponsePosUpdateData data, FriendlyByteBuf buf) {
            buf.writeUUID(data.uuid);
            buf.writeBlockPos(data.correctPos);
        }

        @Override
        public CanineTrackerData.ResponsePosUpdateData decode(FriendlyByteBuf buf) {
            UUID uuid = buf.readUUID();
            BlockPos pos = buf.readBlockPos();
            return new CanineTrackerData.ResponsePosUpdateData(uuid, pos);
        }

        @Override
        public void handle(CanineTrackerData.ResponsePosUpdateData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    return;
                }
                CanineTrackerLocateRenderer.correctPos(data.uuid, data.correctPos);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestPosUpdatePacket
    implements IPacket<CanineTrackerData.RequestPosUpdateData> {
        @Override
        public void encode(CanineTrackerData.RequestPosUpdateData data, FriendlyByteBuf buf) {
            buf.writeUUID(data.uuid);
            buf.writeBlockPos(data.pos);
        }

        @Override
        public CanineTrackerData.RequestPosUpdateData decode(FriendlyByteBuf buf) {
            return new CanineTrackerData.RequestPosUpdateData(buf.readUUID(), buf.readBlockPos());
        }

        @Override
        public void handle(CanineTrackerData.RequestPosUpdateData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                ItemStack stack = sender.getMainHandItem();
                if (!(stack.getItem() instanceof CanineTrackerItem)) {
                    return;
                }
                DogLocationStorage storage = DogLocationStorage.get(sender.level());
                DogLocationData entry = storage.getData(data.uuid);
                if (entry == null) {
                    return;
                }
                UUID owner_id = entry.getOwnerId();
                if (owner_id == null) {
                    return;
                }
                if (!owner_id.equals(sender.getUUID())) {
                    return;
                }
                Vec3 correct_pos = entry.getPos();
                if (correct_pos == null) {
                    return;
                }
                BlockPos correct_blockpos = new BlockPos(Mth.floor((double)correct_pos.x), Mth.floor((double)correct_pos.y), Mth.floor((double)correct_pos.z));
                if (correct_blockpos.distSqr((Vec3i)data.pos) < 4.0) {
                    return;
                }
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new CanineTrackerData.ResponsePosUpdateData(data.uuid, correct_blockpos));
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class StartLocatingPacket
    implements IPacket<CanineTrackerData.StartLocatingData> {
        @Override
        public void encode(CanineTrackerData.StartLocatingData data, FriendlyByteBuf buf) {
            buf.writeUUID(data.uuid);
        }

        @Override
        public CanineTrackerData.StartLocatingData decode(FriendlyByteBuf buf) {
            UUID uuid = buf.readUUID();
            return new CanineTrackerData.StartLocatingData(uuid);
        }

        @Override
        public void handle(CanineTrackerData.StartLocatingData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                ServerPlayer player = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                ItemStack stack = player.getMainHandItem();
                if (!(stack.getItem() instanceof CanineTrackerItem)) {
                    return;
                }
                DogLocationStorage storage = DogLocationStorage.get(player.level());
                DogLocationData dogData = storage.getData(data.uuid);
                if (dogData == null) {
                    return;
                }
                CompoundTag tag = ItemUtil.getTag(stack);
                if (tag == null) {
                    return;
                }
                BlockPos pos = BlockPos.containing((Position)dogData.getPos());
                tag.putUUID("uuid", data.uuid);
                tag.putString("name", dogData.getDogName());
                tag.putInt("posX", pos.getX());
                tag.putInt("posY", pos.getY());
                tag.putInt("posZ", pos.getZ());
                tag.putInt("locateColor", dogData.getLocateColor());
                ItemUtil.putTag(stack, tag);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ResponseDogsPackets
    implements IPacket<CanineTrackerData.ResponseDogsData> {
        @Override
        public void encode(CanineTrackerData.ResponseDogsData data, FriendlyByteBuf buf) {
            int size = data.entries.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                Triple<UUID, String, BlockPos> payload = data.entries.get(i);
                UUID uuid = (UUID)payload.getLeft();
                String name = (String)payload.getMiddle();
                BlockPos pos = (BlockPos)payload.getRight();
                if (uuid == null) {
                    uuid = Util.NIL_UUID;
                }
                if (name == null) {
                    name = "noname";
                }
                if (pos == null) {
                    pos = BlockPos.ZERO;
                }
                buf.writeUUID(uuid);
                buf.writeUtf(name);
                buf.writeBlockPos(pos);
            }
        }

        @Override
        public CanineTrackerData.ResponseDogsData decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<Triple<UUID, String, BlockPos>> newDogsLs = new ArrayList<Triple<UUID, String, BlockPos>>(size);
            for (int i = 0; i < size; ++i) {
                UUID id = buf.readUUID();
                String name = buf.readUtf();
                BlockPos pos = buf.readBlockPos();
                Triple payload = Triple.of((Object)id, (Object)name, (Object)pos);
                newDogsLs.add((Triple<UUID, String, BlockPos>)payload);
            }
            return new CanineTrackerData.ResponseDogsData(newDogsLs);
        }

        @Override
        public void handle(CanineTrackerData.ResponseDogsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Screen patt0$temp;
                    Minecraft mc = Minecraft.getInstance();
                    if (mc.screen != null && (patt0$temp = mc.screen) instanceof CanineTrackerScreen) {
                        CanineTrackerScreen scr = (CanineTrackerScreen)patt0$temp;
                        scr.assignResponse(data.entries);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RequestDogsPacket
    implements IPacket<CanineTrackerData.RequestDogsData> {
        @Override
        public void encode(CanineTrackerData.RequestDogsData data, FriendlyByteBuf buf) {
        }

        @Override
        public CanineTrackerData.RequestDogsData decode(FriendlyByteBuf buf) {
            return new CanineTrackerData.RequestDogsData();
        }

        @Override
        public void handle(CanineTrackerData.RequestDogsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                DogLocationStorage storage = DogLocationStorage.get(sender.level());
                List<Triple<UUID, String, BlockPos>> dogLs = storage.getDogs((LivingEntity)sender, (ResourceKey<Level>)sender.level().dimension()).filter(dogLoc -> dogLoc.shouldDisplay(sender.level(), (Player)sender, InteractionHand.MAIN_HAND)).map(dogLoc -> Triple.of((Object)dogLoc.getDogId(), (Object)dogLoc.getDogName(), (Object)new BlockPos(Mth.floor((double)dogLoc.getPos().x), Mth.floor((double)dogLoc.getPos().y), Mth.floor((double)dogLoc.getPos().z)))).collect(Collectors.toList());
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new CanineTrackerData.ResponseDogsData(dogLs));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

