/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.client.screen.AmnesiaBoneScreen.AmneisaBoneScreen;
import doggytalents.client.screen.AmnesiaBoneScreen.screen.DogForceMigrateOwnerScreen;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AmnesiaBoneItem
extends Item
implements IDogItem {
    public AmnesiaBoneItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level level, Player player, InteractionHand hand) {
        UUID ownerUUID = dog.getOwnerUUID();
        if (ownerUUID == null) {
            return InteractionResult.FAIL;
        }
        if (level.isClientSide) {
            this.handleOpenScreenOnClient(level, dog, player, hand, ownerUUID);
            return InteractionResult.SUCCESS;
        }
        this.requestOwnership(level, ownerUUID, player, hand, dog);
        return InteractionResult.SUCCESS;
    }

    private void handleOpenScreenOnClient(Level level, AbstractDog dogIn, Player player, InteractionHand hand, UUID dogOwnerUUID) {
        boolean isOpAndCreative;
        if (!level.isClientSide) {
            return;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (dogOwnerUUID.equals(player.getUUID())) {
            AmneisaBoneScreen.open(dog);
            return;
        }
        boolean bl = isOpAndCreative = player.hasPermissions(4) && player.getAbilities().instabuild;
        if (isOpAndCreative && player.isShiftKeyDown()) {
            DogForceMigrateOwnerScreen.open(dog);
        }
    }

    private void requestOwnership(Level level, UUID ownerUUID, Player player, InteractionHand hand, AbstractDog dog) {
        if (level.isClientSide) {
            return;
        }
        UUID playerUUID = player.getUUID();
        if (ownerUUID.equals(playerUUID)) {
            return;
        }
        if (!(dog instanceof Dog)) {
            return;
        }
        Dog d = (Dog)dog;
        if (!d.willObeyOthers()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.doggytalents.amnesia_bone.reject").withStyle(ChatFormatting.RED), true);
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() != this) {
            return;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        if (tag.hasUUID("request_uuid") && tag.getUUID("request_uuid").equals(playerUUID)) {
            return;
        }
        tag.putUUID("request_uuid", player.getUUID());
        tag.putString("request_str", player.getName().getString());
        ItemUtil.putTag(stack, tag);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        String desc_id = this.getDescriptionId(stack) + ".description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
        CompoundTag tag = ItemUtil.getTag(stack);
        if (tag == null) {
            return;
        }
        if (tag.contains("amnesia_bone_used_time", 3)) {
            components.add((Component)Component.translatable((String)"item.doggytalents.amnesia_bone.use_status", (Object[])new Object[]{AmnesiaBoneItem.getUseCap() - tag.getInt("amnesia_bone_used_time"), AmnesiaBoneItem.getUseCap()}).withStyle(ChatFormatting.RED));
        }
        if (tag.contains("request_str", 8)) {
            components.add((Component)Component.translatable((String)"item.doggytalents.amnesia_bone.status", (Object[])new Object[]{tag.getString("request_str")}).withStyle(ChatFormatting.GRAY));
        }
    }

    public static int getUseCap() {
        return 8;
    }

    public static int getUntameXPCost() {
        return 3;
    }

    public static int getMigrateOwnerXPCost() {
        return 5;
    }
}

