/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.feature.DogMode;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAttackManager;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class DoggyBeamEntity
extends ThrowableProjectile {
    public DoggyBeamEntity(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public DoggyBeamEntity(Level worldIn, LivingEntity livingEntityIn) {
        super(DoggyEntityTypes.DOG_BEAM.get(), livingEntityIn, worldIn);
    }

    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            if (!this.level().isClientSide) {
                this.mayTriggerNearbyDogs((EntityHitResult)result);
            } else {
                for (int j = 0; j < 8; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    private void mayTriggerNearbyDogs(EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity hit = (LivingEntity)entity;
        Entity entity2 = this.getOwner();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player thrower = (Player)entity2;
        boolean do_cooldown = false;
        AABB trigger_bb = thrower.getBoundingBox().inflate(16.0, 8.0, 16.0);
        List trigger_list = this.level().getEntitiesOfClass(Dog.class, trigger_bb, filter_dog -> this.isEligibleDog((Dog)filter_dog, hit, (LivingEntity)thrower));
        do_cooldown = !trigger_list.isEmpty();
        int trigger_limit = (Integer)ConfigHandler.SERVER.TACTICAL_LIMIT.get();
        if (trigger_limit > 0 && trigger_list.size() > trigger_limit) {
            Collections.shuffle(trigger_list);
            trigger_list = trigger_list.subList(0, trigger_limit);
        }
        for (Dog dog : trigger_list) {
            DogAttackManager attack_manager = dog.dogAttackManager;
            attack_manager.setDogTaticalTarget(hit);
        }
        if (do_cooldown) {
            thrower.getCooldowns().addCooldown((Item)DoggyItems.WHISTLE.get(), 40);
        }
    }

    private boolean isEligibleDog(Dog dog, LivingEntity target, LivingEntity thrower) {
        if (dog == target) {
            return false;
        }
        if (dog.isOrderedToSit()) {
            return false;
        }
        UUID dog_owner_id = dog.getOwnerUUID();
        UUID thrower_id = thrower.getUUID();
        if (dog_owner_id == null) {
            return false;
        }
        if (!dog_owner_id.equals(thrower_id)) {
            return false;
        }
        if (!dog.wantsToAttack(target, thrower)) {
            return false;
        }
        double target_dist_sqr = dog.distanceToSqr((Entity)target);
        DogAttackManager attack_manager = dog.dogAttackManager;
        double range_far = attack_manager.getFarFollowRange();
        boolean tactical_condition = dog.getMode() == DogMode.TACTICAL && target_dist_sqr < range_far * range_far;
        return tactical_condition;
    }

    protected void defineSynchedData(SynchedEntityData.Builder b) {
    }
}

