/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.anim;

import doggytalents.common.util.Util;

public class DogAnimationState {
    private long lastTimeMillis = 0L;
    private long accumulatedTimeMillis;
    private boolean started = false;

    public void start(int startTick) {
        this.started = true;
        this.lastTimeMillis = Util.tickMayWithPartialToMillis(startTick);
        this.accumulatedTimeMillis = 0L;
    }

    public void stop() {
        this.started = false;
    }

    public void updateTime(float timestampTickWithPartial, float speedModifier) {
        if (this.isStarted()) {
            long i = Util.tickMayWithPartialToMillis(timestampTickWithPartial);
            this.accumulatedTimeMillis += this.getTimeForAccumulate(i, speedModifier);
            this.lastTimeMillis = i;
        }
    }

    private long getTimeForAccumulate(long timestampMillis, float speedModifier) {
        long dtime = timestampMillis - this.lastTimeMillis;
        double ret = (double)dtime * (double)speedModifier;
        return (long)ret;
    }

    public long getAccumulatedTimeMillis() {
        return this.accumulatedTimeMillis;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void resolveLatency(int resolveTick, int correctAnimPassedTick, float speedModifier) {
        if (!this.started) {
            return;
        }
        this.lastTimeMillis = Util.tickMayWithPartialToMillis(resolveTick);
        double correctTickWithPartial = Util.tickMayWithPartialToMillis(correctAnimPassedTick);
        this.accumulatedTimeMillis = (long)(correctTickWithPartial * (double)speedModifier);
    }
}

