/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class DogSwimNodeEvaluator
extends SwimNodeEvaluator {
    private boolean checkLand = false;
    private Dog dog;

    public DogSwimNodeEvaluator(Dog dog) {
        super(false);
        this.dog = dog;
    }

    public int getNeighbors(Node[] buffer, Node currentNode) {
        this.checkLand = currentNode.type == PathType.WATER;
        int ret = super.getNeighbors(buffer, currentNode);
        this.checkLand = false;
        return ret;
    }

    @Nullable
    protected Node findAcceptedNode(int p_263032_, int p_263066_, int p_263105_) {
        float f;
        Node node = null;
        PathType blockpathtypes = this.getCachedBlockType(p_263032_, p_263066_, p_263105_);
        if (blockpathtypes == PathType.WATER) {
            float f2 = this.mob.getPathfindingMalus(blockpathtypes);
            if (f2 >= 0.0f) {
                node = this.getNode(p_263032_, p_263066_, p_263105_);
                node.type = blockpathtypes;
                node.costMalus = Math.max(node.costMalus, f2);
                if (this.mob.level().getFluidState(new BlockPos(p_263032_, p_263066_, p_263105_)).isEmpty()) {
                    node.costMalus += 8.0f;
                }
            }
        } else if (this.checkLand && blockpathtypes == PathType.WALKABLE && (f = this.mob.getPathfindingMalus(blockpathtypes)) >= 0.0f) {
            node = this.getNode(p_263032_, p_263066_ + 1, p_263105_);
            node.type = blockpathtypes;
            node.costMalus = Math.max(node.costMalus, f);
        }
        return node;
    }

    public Node getStart() {
        Node ret = super.getStart();
        if (this.dog.isInWater()) {
            ret.type = PathType.WATER;
        }
        return ret;
    }

    public PathType getPathTypeOfMob(PathfindingContext context, int x, int y, int z, Mob dog) {
        Level level = dog.level();
        BlockPos.MutableBlockPos checking_pos = new BlockPos.MutableBlockPos();
        for (int i = y; i < y + this.entityHeight; ++i) {
            boolean checkedWalkable;
            checking_pos.set(x, i, z);
            BlockState state = level.getBlockState((BlockPos)checking_pos);
            FluidState fluid = state.getFluidState();
            boolean bl = checkedWalkable = this.checkLand && i == y && this.checkLand((BlockPos)checking_pos, state, (BlockGetter)level, dog);
            if (checkedWalkable) {
                return PathType.WALKABLE;
            }
            if (fluid.is(FluidTags.WATER)) continue;
            return PathType.BLOCKED;
        }
        return PathType.WATER;
    }

    private boolean checkLand(BlockPos currentPos, BlockState currenState, BlockGetter level, Mob dog) {
        if (currenState.is(Blocks.WATER)) {
            return false;
        }
        if (currenState.isAir()) {
            return false;
        }
        PathType walkType = WalkNodeEvaluator.getPathTypeStatic((Mob)dog, (BlockPos)currentPos.above().mutable());
        return walkType == PathType.WATER_BORDER || walkType == PathType.WALKABLE;
    }
}

