/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAttackManager;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.entity.ai.nav.DogFlyingNavigation;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DogMeleeAttackGoal
extends Goal
implements DogAiManager.IHasTickNonRunning {
    protected final Dog dog;
    private final double speedModifier;
    private int ticksUntilPathRecalc = 10;
    private int ticksUntilNextAttack;
    private final int timeOutTick = 40;
    private int waitingTick;
    private BlockPos.MutableBlockPos dogPos0;
    private boolean immediatelyPathRecalcWhenStop = false;
    private Path initialPath = null;
    private int detectReachPenalty = 0;
    private final float START_LEAPING_AT_DIS_SQR = 2.0f;
    private final float DONT_LEAP_AT_DIS_SQR = 1.0f;
    private final float LEAP_YD = 0.4f;

    public DogMeleeAttackGoal(Dog dog) {
        this.dog = dog;
        this.speedModifier = 1.0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target;
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.isDogLowHealth() && this.dog.getLowHealthStrategy() == Dog.LowHealthStrategy.RUN_AWAY) {
            return false;
        }
        if (this.dog.fallDistance > 7.0f) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            LivingEntity owner = this.dog.getOwner();
            if (owner != null && this.dog.distanceToSqr((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            restriction = !this.dog.patrolTargetLock();
        }
        if ((target = this.dog.getTarget()) == null) {
            return false;
        }
        if (!target.isAlive()) {
            this.dog.setTarget(null);
            return false;
        }
        if (target.getY() >= (double)this.dog.level().getMaxBuildHeight()) {
            return false;
        }
        if (this.dog.getDogRangedAttack().isApplicable(this.dog)) {
            return false;
        }
        if (restriction && !this.dog.isWithinRestriction(target.blockPosition())) {
            return false;
        }
        if (this.detectReachPenalty > 0) {
            return false;
        }
        double d0 = this.dog.distanceToSqr((Entity)target);
        this.detectReachPenalty = 5;
        this.detectReachPenalty += d0 > 256.0 ? 10 : 5;
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        if (attack_manager.hasTaticalTarget()) {
            this.detectReachPenalty = 25;
            attack_manager.setDogFarChasingTarget(true);
            this.initialPath = this.dog.getNavigation().createPath((Entity)target, 1);
            attack_manager.setDogFarChasingTarget(false);
            return this.initialPath != null;
        }
        Path p = this.dog.getNavigation().createPath((Entity)target, 1);
        if (p == null) {
            return false;
        }
        if (!DogUtil.canPathReachTargetBlock(this.dog, p, target.blockPosition(), 1, this.dog.getMaxFallDistance())) {
            this.dog.setTarget(null);
            return false;
        }
        this.initialPath = p;
        return true;
    }

    @Override
    public void tickDogWhenNotRunning() {
        if (this.detectReachPenalty > 0) {
            --this.detectReachPenalty;
        }
    }

    public boolean canContinueToUse() {
        if (!this.dog.getMode().shouldAttack()) {
            return false;
        }
        if (this.dog.fallDistance > 7.0f) {
            return false;
        }
        boolean restriction = false;
        if (this.dog.getMode().shouldFollowOwner() && this.dog.getCombatReturnStrategy() != Dog.CombatReturnStrategy.NONE) {
            LivingEntity owner = this.dog.getOwner();
            if (owner != null && this.dog.distanceToSqr((Entity)owner) > this.getMaxDistanceAwayFromOwner()) {
                return false;
            }
        } else {
            boolean bl = restriction = !this.dog.patrolTargetLock();
        }
        if (this.waitingTick > this.timeOutTick) {
            return false;
        }
        LivingEntity livingentity = this.dog.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (livingentity.getY() >= (double)this.dog.level().getMaxBuildHeight()) {
            return false;
        }
        if (restriction && !this.dog.isWithinRestriction(livingentity.blockPosition())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
    }

    public void start() {
        if (this.initialPath != null) {
            this.dog.getNavigation().moveTo(this.initialPath, this.speedModifier);
        }
        this.ticksUntilPathRecalc = 10;
        this.ticksUntilNextAttack = 0;
        this.waitingTick = 0;
        this.dogPos0 = this.dog.blockPosition().mutable();
        this.immediatelyPathRecalcWhenStop = this.checkCurrentPathIfCanDoImmediateRecalc();
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = true;
        if (attack_manager.hasTaticalTarget()) {
            attack_manager.setDogFarChasingTarget(true);
        }
    }

    public void stop() {
        this.initialPath = null;
        this.dog.setTarget(null);
        this.dog.getNavigation().stop();
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        attack_manager.attacking = false;
        attack_manager.setDogFarChasingTarget(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double min_dist;
        double d0;
        LivingEntity e = this.dog.getTarget();
        if (e == null) {
            return;
        }
        PathNavigation n = this.dog.getNavigation();
        BlockPos dog_bp = this.dog.blockPosition();
        BlockPos target_bp = e.blockPosition();
        DogAttackManager attack_manager = this.dog.dogAttackManager;
        if (attack_manager.isDogFarChasingTarget() && (d0 = this.dog.distanceToSqr(e.getX(), e.getY(), e.getZ())) < (min_dist = (double)(attack_manager.getStandardFollowRange() / 2 + 1)) * min_dist) {
            attack_manager.setDogFarChasingTarget(false);
        }
        if (this.dog.isDogFlying() && this.flyingDogDashToTargetIfNeeded(e)) {
            return;
        }
        if (dog_bp.equals((Object)this.dogPos0)) {
            ++this.waitingTick;
        } else {
            this.waitingTick = 0;
            this.dogPos0.set(dog_bp.getX(), dog_bp.getY(), dog_bp.getZ());
        }
        this.dog.getLookControl().setLookAt((Entity)e, 30.0f, 30.0f);
        d0 = this.dog.distanceToSqr(e.getX(), e.getY(), e.getZ());
        if (this.ticksUntilPathRecalc <= 0) {
            this.ticksUntilPathRecalc = 10;
            if (attack_manager.isDogFarChasingTarget()) {
                this.ticksUntilPathRecalc = 20;
            }
            n.moveTo((Entity)e, this.speedModifier);
            this.immediatelyPathRecalcWhenStop = this.checkCurrentPathIfCanDoImmediateRecalc();
        }
        --this.ticksUntilPathRecalc;
        --this.ticksUntilNextAttack;
        if (n.isDone() && dog_bp.distSqr((Vec3i)target_bp) <= 2.25 && !this.canReachTarget(e, d0) && this.isTargetInSafeArea(this.dog, e, target_bp)) {
            this.dog.getMoveControl().setWantedPosition(e.getX(), e.getY(), e.getZ(), this.speedModifier);
        }
        if (!attack_manager.isDogFarChasingTarget() && this.immediatelyPathRecalcWhenStop && n.isDone() && this.dog.tickCount % 2 != 0 && !this.canReachTarget(e, d0)) {
            this.ticksUntilPathRecalc = 0;
        }
        if (this.checkAndPerformAttack(e, d0)) {
            this.waitingTick = 0;
        }
        this.checkAndLeapAtTarget(e);
    }

    protected void checkAndLeapAtTarget(LivingEntity target) {
        if (!this.canLeapAtTarget(target)) {
            return;
        }
        Vec3 vec3 = this.dog.getDeltaMovement();
        Vec3 vec31 = new Vec3(target.getX() - this.dog.getX(), 0.0, target.getZ() - this.dog.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(0.4);
        }
        double d = vec31.x;
        Objects.requireNonNull(this);
        this.dog.setDeltaMovement(d, 0.4f, vec31.z);
    }

    private boolean flyingDogDashToTargetIfNeeded(LivingEntity target) {
        double d_sqr = this.dog.distanceToSqr((Entity)target);
        if (d_sqr > 16.0) {
            return false;
        }
        if (this.dog.tickCount % 5 != 0) {
            return false;
        }
        PathNavigation pathNavigation = this.dog.getNavigation();
        if (!(pathNavigation instanceof DogFlyingNavigation)) {
            return false;
        }
        DogFlyingNavigation flyNav = (DogFlyingNavigation)pathNavigation;
        if (!flyNav.canDashToTarget(target)) {
            return false;
        }
        flyNav.stop();
        this.dog.getMoveControl().setWantedPosition(target.position().x, target.position().y, target.position().z, 2.0);
        this.ticksUntilPathRecalc = 10;
        return true;
    }

    protected boolean canLeapAtTarget(@NotNull LivingEntity target) {
        if (this.dog.isVehicle()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        if (!target.onGround()) {
            return false;
        }
        double d0 = this.dog.distanceToSqr((Entity)target);
        if (!(d0 >= 1.0) || !(d0 <= 2.0)) {
            return false;
        }
        if (this.dog.getRandom().nextInt(3) != 0) {
            return false;
        }
        BlockPos tpos = target.blockPosition();
        if (WalkNodeEvaluator.getPathTypeStatic((Mob)this.dog, (BlockPos)tpos.mutable()) != PathType.WALKABLE) {
            return false;
        }
        Vec3 v_offset = new Vec3(target.getX() - this.dog.getX(), 0.0, target.getZ() - this.dog.getZ()).normalize();
        Vec3 v_dog = this.dog.position();
        for (int i = 1; i <= 3; ++i) {
            if (WalkNodeEvaluator.getPathTypeStatic((Mob)this.dog, (BlockPos)BlockPos.containing((Position)(v_dog = v_dog.add(v_offset))).mutable()) == PathType.WALKABLE) continue;
            return false;
        }
        return true;
    }

    private boolean checkCurrentPathIfCanDoImmediateRecalc() {
        boolean ground_nav_cannot_update;
        Path path = this.dog.getNavigation().getPath();
        boolean bl = ground_nav_cannot_update = this.dog.isDefaultNavigation() && !this.dog.onGround();
        if (path == null && !ground_nav_cannot_update) {
            return false;
        }
        return path == null || path.getNodeCount() <= 5;
    }

    protected boolean checkAndPerformAttack(LivingEntity target, double distanceToTargetSqr) {
        if (this.canReachTarget(target, distanceToTargetSqr) && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.dog.swing(InteractionHand.MAIN_HAND);
            this.dog.doHurtTarget((Entity)target);
            return true;
        }
        return false;
    }

    protected boolean isTargetInSafeArea(Dog dog, LivingEntity target, BlockPos target_bp) {
        PathType type = WalkNodeEvaluator.getPathTypeStatic((Mob)dog, (BlockPos)target_bp.mutable());
        if (type == PathType.OPEN) {
            return false;
        }
        return !DogUtil.isDangerPathType(type = dog.inferType(type, InferTypeContext.getDefault()));
    }

    protected boolean canReachTarget(LivingEntity target, double distanceToTargetSqr) {
        return this.getAttackReachSqr(target) >= distanceToTargetSqr;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.adjustedTickDelay(20);
    }

    protected double getAttackReachSqr(LivingEntity target) {
        return this.dog.getBbWidth() * 2.0f * this.dog.getBbWidth() * 2.0f + target.getBbWidth();
    }

    protected double getMaxDistanceAwayFromOwner() {
        boolean has_tatical;
        double ret = 400.0;
        if (this.dog.getCombatReturnStrategy() == Dog.CombatReturnStrategy.FAR) {
            ret = 1024.0;
        }
        if (has_tatical = this.dog.dogAttackManager.hasTaticalTarget()) {
            ret += 10.0;
        }
        return ret;
    }
}

