/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyBlocks;
import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DogGoRestOnBedGoalDefeated
extends Goal {
    private final int SEARCH_RADIUS = 5;
    private Dog dog;
    private int tickTillSearch = 10;
    private int tickTillPathRecalc = 0;
    private BlockPos targetBed;
    private int tickTillValidateNeabyDogs = 5;

    public DogGoRestOnBedGoalDefeated(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.dog.isDefeated()) {
            return false;
        }
        if (this.dog.isOrderedToSit()) {
            return false;
        }
        this.targetBed = null;
        if (--this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            this.targetBed = this.searchForBed();
        }
        return this.targetBed != null;
    }

    public boolean canContinueToUse() {
        if (!this.dog.isDefeated()) {
            return false;
        }
        if (this.dog.isOrderedToSit()) {
            return false;
        }
        return this.targetBed != null;
    }

    public void start() {
        this.tickTillPathRecalc = 0;
        this.dog.setInSittingPose(false);
    }

    public void stop() {
        this.dog.getNavigation().stop();
        this.dog.setInSittingPose(false);
        if (this.dog.getAnim() == DogAnimation.LIE_DOWN_IDLE) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    public void tick() {
        boolean onBed;
        this.idleIfLyingElseInvalidate();
        this.validateTarget();
        if (this.targetBed == null) {
            return;
        }
        PathNavigation nav = this.dog.getNavigation();
        double d_targetBed = this.dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)this.targetBed));
        boolean bl = onBed = d_targetBed < 0.35;
        if (!onBed && --this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            nav.moveTo((double)this.targetBed.getX() + 0.5, (double)this.targetBed.getY(), (double)this.targetBed.getZ() + 0.5, 1.0);
        }
        if (nav.isDone() && !onBed) {
            this.dog.getMoveControl().setWantedPosition((double)this.targetBed.getX() + 0.5, (double)this.targetBed.getY(), (double)this.targetBed.getZ() + 0.5, 1.0);
        }
        if (d_targetBed < 1.0) {
            if (!this.dog.isInSittingPose() && this.dog.onGround()) {
                this.dog.setSitAnim(DogAnimation.LYING_DOWN);
                this.dog.setInSittingPose(true);
            }
        } else {
            this.dog.setInSittingPose(false);
        }
    }

    private void idleIfLyingElseInvalidate() {
        if (this.dog.getDogPose() == DogPose.LYING_2 && this.dog.getAnim() == DogAnimation.NONE) {
            this.dog.setAnim(DogAnimation.LIE_DOWN_IDLE);
            return;
        }
        if (this.dog.getDogPose() != DogPose.LYING_2 && this.dog.getAnim() == DogAnimation.LIE_DOWN_IDLE) {
            this.dog.setAnim(DogAnimation.NONE);
            return;
        }
    }

    private void validateTarget() {
        if (this.targetBed == null) {
            return;
        }
        int invalidate_dist = 36;
        if (this.dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)this.targetBed)) > (double)invalidate_dist) {
            this.targetBed = null;
            return;
        }
        BlockState state = this.dog.level().getBlockState(this.targetBed);
        if (!this.isBed(state)) {
            this.targetBed = null;
            return;
        }
        if (--this.tickTillValidateNeabyDogs <= 0) {
            List nearby_defeated_dogs;
            this.tickTillValidateNeabyDogs = 5;
            Vec3 bed_center = Vec3.atBottomCenterOf((Vec3i)this.targetBed);
            if (!this.noDogsIsNearby(bed_center, nearby_defeated_dogs = this.dog.level().getEntitiesOfClass(Dog.class, new AABB(bed_center.add(-2.0, -2.0, -2.0), bed_center.add(2.0, 2.0, 2.0)), filter_dog -> filter_dog.isDefeated()))) {
                this.targetBed = null;
                return;
            }
        }
    }

    private BlockPos searchForBed() {
        List nearby_defeated_dogs = this.dog.level().getEntitiesOfClass(Dog.class, this.dog.getBoundingBox().inflate(6.0, 2.0, 6.0), filter_dog -> filter_dog.isDefeated());
        BlockPos dog_b0 = this.dog.blockPosition();
        for (BlockPos bpos : BlockPos.betweenClosed((BlockPos)dog_b0.offset(-5, -1, -5), (BlockPos)dog_b0.offset(5, 1, 5))) {
            BlockState state = this.dog.level().getBlockState(bpos);
            if (!this.isBed(state) || !this.noDogsIsNearby(Vec3.atBottomCenterOf((Vec3i)bpos), nearby_defeated_dogs)) continue;
            return bpos;
        }
        return null;
    }

    private boolean isBed(BlockState state) {
        Block block = state.getBlock();
        if (block == DoggyBlocks.DOG_BED.get()) {
            return true;
        }
        return state.is(BlockTags.BEDS);
    }

    private boolean noDogsIsNearby(Vec3 pos, List<Dog> nearbys) {
        for (Dog dog : nearbys) {
            if (dog == this.dog || !(dog.distanceToSqr(pos) < 0.35)) continue;
            return false;
        }
        return true;
    }
}

