/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.DogGreedyFireSafeSearchPath;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DogGoAwayFromFireGoal
extends Goal {
    private Dog dog;
    private int tickUntilSearch;
    private int lastGoAwayTimestamp;
    private int walkableUntilStop = 1;
    private DogGreedyFireSafeSearchPath path;

    public DogGoAwayFromFireGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.dog.fireImmune()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        int dangerSpot = -1;
        if (--this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 3;
            dangerSpot = this.isDogInDangerSpot(this.dog.position());
        }
        if (dangerSpot == -1) {
            return false;
        }
        this.path = DogGreedyFireSafeSearchPath.create(this.dog, 10);
        if (this.path == null || !this.checkCanReplaceCurrentPath(this.dog, this.path)) {
            this.tickUntilSearch = 5;
            this.path = null;
            return false;
        }
        return true;
    }

    private boolean checkCanReplaceCurrentPath(Dog dog, DogGreedyFireSafeSearchPath new_path) {
        Path current_path = this.dog.getNavigation().getPath();
        if (current_path == null) {
            return true;
        }
        if (current_path.isDone()) {
            return true;
        }
        Node current_next_node = current_path.getNextNode();
        float current_next_malus = dog.getPathfindingMalus(current_next_node.type);
        float new_next_malus = dog.getPathfindingMalus(new_path.getNode((int)0).type);
        return new_next_malus < current_next_malus;
    }

    public boolean canContinueToUse() {
        boolean is_safe;
        if (this.path == null) {
            return false;
        }
        if (this.dog.getNavigation().isDone()) {
            return false;
        }
        boolean bl = is_safe = this.path.getWalkableCount() >= this.walkableUntilStop && this.checkAboveForFallingLava(this.dog.blockPosition());
        return !is_safe;
    }

    public void start() {
        if (this.path == null) {
            return;
        }
        PathNavigation nav = this.dog.getNavigation();
        nav.stop();
        nav.moveTo((Path)this.path, (double)this.dog.getUrgentSpeedModifier());
        BlockPos b0 = this.path.getNode(0).asBlockPos();
        DogUtil.stopAndForceLook(this.dog, b0.getCenter());
        this.dog.getMoveControl().setWantedPosition((double)((float)b0.getX() + 0.5f), (double)b0.getY(), (double)((float)b0.getZ() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
        this.dog.setDogForcePushAvoid(true);
        int tick_since_last = this.dog.tickCount - this.lastGoAwayTimestamp;
        this.walkableUntilStop = tick_since_last >= 20 ? 1 : 2;
    }

    public void stop() {
        this.dog.setDogForcePushAvoid(false);
        this.tickUntilSearch = 5;
        this.lastGoAwayTimestamp = this.dog.tickCount;
        this.proccessEndNode();
        this.dog.getNavigation().stop();
    }

    private void proccessEndNode() {
        if (this.path == null) {
            return;
        }
        Node end_node = this.path.getEndNode();
        if (end_node == null) {
            return;
        }
        BlockPos b0 = end_node.asBlockPos();
        this.dog.getMoveControl().setWantedPosition((double)((float)b0.getX() + 0.5f), (double)b0.getY(), (double)((float)b0.getZ() + 0.5f), (double)this.dog.getUrgentSpeedModifier());
        if (end_node.type != PathType.WALKABLE) {
            this.tickUntilSearch = 20 + this.dog.getRandom().nextInt(3) * 10;
        }
    }

    private byte isDogInDangerSpot(Vec3 pos) {
        double FLUID_BB_DEFLATE = 0.001;
        double half_bbw = 0.5 * (double)this.dog.getBbWidth() - 0.001;
        int min_x = Mth.floor((double)(pos.x - half_bbw)) - 1;
        int min_y = Mth.floor((double)pos.y);
        int min_z = Mth.floor((double)(pos.z - half_bbw)) - 1;
        int max_x = Mth.floor((double)(pos.x + half_bbw)) + 1;
        int max_y = Mth.floor((double)(pos.y + 1.0));
        int max_z = Mth.floor((double)(pos.z + half_bbw)) + 1;
        byte ret = -1;
        for (BlockPos check_pos : BlockPos.betweenClosed((int)min_x, (int)min_y, (int)min_z, (int)max_x, (int)max_y, (int)max_z)) {
            boolean is_corner;
            boolean bl = is_corner = !(check_pos.getX() != min_x && check_pos.getX() != max_x || check_pos.getZ() != min_z && check_pos.getZ() != max_z);
            if (is_corner) continue;
            AABB dog_bb = this.dog.getBoundingBox();
            boolean above_outside = check_pos.getY() > min_y && !dog_bb.intersects(new AABB(new BlockPos(check_pos.getX(), min_y, check_pos.getZ())));
            if (above_outside) continue;
            BlockState state = this.dog.level().getBlockState(check_pos);
            if (state.getFluidState().is(FluidTags.LAVA)) {
                return 1;
            }
            AABB check_pos_bb = new AABB(check_pos);
            boolean pos_within_dog_bb = this.dog.getBoundingBox().intersects(check_pos_bb);
            if (!pos_within_dog_bb) continue;
            boolean is_burning = WalkNodeEvaluator.isBurningBlock((BlockState)state);
            if (is_burning) {
                return 1;
            }
            if (check_pos.getY() != min_y) continue;
            BlockPos pos_below = DogUtil.getSurfaceStandingInPos(this.dog, check_pos.getX(), check_pos.getZ()).below();
            BlockState state_below = this.dog.level().getBlockState(pos_below);
            boolean full_collision_burning_block = WalkNodeEvaluator.isBurningBlock((BlockState)state_below) && state_below.isCollisionShapeFullBlock((BlockGetter)this.dog.level(), pos_below);
            if (!full_collision_burning_block) continue;
            return 1;
        }
        return ret;
    }

    private boolean checkAboveForFallingLava(BlockPos pos) {
        BlockPos pos_above = pos.above();
        BlockState state_above = this.dog.level().getBlockState(pos_above);
        return !state_above.is(Blocks.LAVA);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

