/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.widget.DoggySpin;

import doggytalents.client.screen.widget.DoggySpin.DoggySpinModel;
import doggytalents.common.config.ConfigHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.event.ScreenEvent;

public class DoggySpin
extends AbstractWidget {
    private int size;
    private long accumulatedTime = 0L;
    private long lastAccumulate = 0L;
    private static final DoggySpin spinWidget = new DoggySpin(0, 0, 128);

    public DoggySpin(int x, int y, int size) {
        super(x, y, size, size, (Component)Component.empty());
        this.size = size;
        this.lastAccumulate = System.currentTimeMillis();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        this.updateAcculumlatedMillis();
        int mx = this.getX() + this.getWidth() / 2;
        int my = this.getY() + this.getHeight() / 2;
        DoggySpinModel.get().prepareRender(this.accumulatedTime);
        DoggySpinModel.get().renderGui(graphics, mx, my);
    }

    private void updateAcculumlatedMillis() {
        long current_time = System.currentTimeMillis();
        long time_since = current_time - this.lastAccumulate;
        if (time_since > 0L) {
            this.accumulatedTime = (long)((double)this.accumulatedTime + Mth.clamp((double)((double)time_since * 0.9), (double)0.0, (double)34.0));
            this.lastAccumulate = current_time;
        }
    }

    public void chooseStyle() {
        DoggySpinModel.get().configureRandomStyle();
        this.accumulatedTime = 0L;
        this.lastAccumulate = System.currentTimeMillis();
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (DoggySpin.isLevelLoadingScreen((ScreenEvent)event)) {
            spinWidget.chooseStyle();
        }
    }

    public static void onScreenRenderForeground(ScreenEvent.Render.Post event) {
        if (!DoggySpin.isLevelLoadingScreen((ScreenEvent)event)) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.WORD_LOAD_ICON.get()).booleanValue()) {
            return;
        }
        int x = (Boolean)ConfigHandler.CLIENT.WORD_LOAD_ICON_R.get() != false ? event.getScreen().width - DoggySpin.spinWidget.size : 0;
        int y = event.getScreen().height - spinWidget.getHeight();
        spinWidget.setX(x += ((Integer)ConfigHandler.CLIENT.WORD_LOAD_ICON_X.get()).intValue());
        spinWidget.setY(y += ((Integer)ConfigHandler.CLIENT.WORD_LOAD_ICON_Y.get()).intValue());
        spinWidget.render(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
    }

    private static boolean isLevelLoadingScreen(ScreenEvent event) {
        Screen screen = event.getScreen();
        if (screen == null) {
            return false;
        }
        return screen.getClass() == LevelLoadingScreen.class;
    }
}

